/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.search;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.AddSearchScoreExpression;
import com.mongodb.client.model.search.ConstantSearchScoreExpression;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.GaussSearchScoreExpression;
import com.mongodb.client.model.search.Log1pSearchScoreExpression;
import com.mongodb.client.model.search.LogSearchScoreExpression;
import com.mongodb.client.model.search.MultiplySearchScoreExpression;
import com.mongodb.client.model.search.PathSearchScoreExpression;
import com.mongodb.client.model.search.RelevanceSearchScoreExpression;
import com.mongodb.client.model.search.SearchConstructibleBson;
import com.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.mongodb.internal.client.model.Util;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchScoreExpression
extends Bson {
    public static RelevanceSearchScoreExpression relevanceExpression() {
        return new SearchConstructibleBson((Bson)new BsonDocument("score", (BsonValue)new BsonString("relevance")));
    }

    public static PathSearchScoreExpression pathExpression(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("path", (Bson)new Document("value", (Object)Assertions.notNull("path", path).toValue()));
    }

    public static ConstantSearchScoreExpression constantExpression(float value) {
        return new SearchConstructibleBson((Bson)new BsonDocument("constant", (BsonValue)new BsonDouble((double)value)));
    }

    public static GaussSearchScoreExpression gaussExpression(final double origin, final PathSearchScoreExpression path, final double scale) {
        Assertions.notNull("path", path);
        Bson value = new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument pathDoc = path.toBsonDocument(documentClass, codecRegistry);
                Assertions.assertTrue(pathDoc.size() == 1);
                return new BsonDocument("origin", (BsonValue)new BsonDouble(origin)).append("path", (BsonValue)pathDoc.values().iterator().next()).append("scale", (BsonValue)new BsonDouble(scale));
            }

            public String toString() {
                return new Document("origin", (Object)origin).append("path", (Object)path).append("scale", (Object)scale).toString();
            }
        };
        return new SearchConstructibleBsonElement("gauss", value);
    }

    public static LogSearchScoreExpression logExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson((Bson)new Document("log", (Object)Assertions.notNull("expression", expression)));
    }

    public static Log1pSearchScoreExpression log1pExpression(SearchScoreExpression expression) {
        return new SearchConstructibleBson((Bson)new Document("log1p", (Object)Assertions.notNull("expression", expression)));
    }

    public static AddSearchScoreExpression addExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull("expressions", expressions);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson((Bson)new Document("add", expressions));
    }

    public static MultiplySearchScoreExpression multiplyExpression(Iterable<? extends SearchScoreExpression> expressions) {
        Assertions.notNull("expressions", expressions);
        Assertions.isTrueArgument("expressions must contain at least 2 elements", Util.sizeAtLeast(expressions, 2));
        return new SearchConstructibleBson((Bson)new Document("multiply", expressions));
    }

    public static SearchScoreExpression of(Bson expression) {
        return new SearchConstructibleBson(Assertions.notNull("expression", expression));
    }
}

