/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import zeenea.connector.commons.http.client.EntityMapper;
import zeenea.connector.commons.xml.XmlDeserializationException;
import zeenea.connector.commons.xml.XmlMapper;

public enum HttpXmlMapper implements EntityMapper
{
    INSTANCE;

    private final XmlMapper mapper = XmlMapper.of();

    public static HttpXmlMapper of() {
        return INSTANCE;
    }

    @Override
    public <T> T readEntity(HttpEntity entity, JavaType type) throws IOException, ParseException {
        String body = EntityUtils.toString((HttpEntity)entity);
        try {
            return (T)this.mapper.getMapper().readValue(body, type);
        }
        catch (JsonProcessingException e) {
            throw new XmlDeserializationException(String.format("Failed parsing response to '%s': '%s'", type.getTypeName(), e.getMessage()), body, (Throwable)e);
        }
    }

    @Override
    public <T> HttpEntity writeAsEntity(T content) {
        return new ByteArrayEntity(this.mapper.writeAsBytes(content), ContentType.APPLICATION_XML);
    }

    @Override
    public <T> String prettyPrint(T o) {
        return this.mapper.prettyPrint(o);
    }
}

