package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link VariableJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableJson.builder()}.
 */
@Generated(from = "VariableJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVariableJson implements VariableJson {
  private final VariableDefinitionJson definition;
  private final @Nullable String value;

  private ImmutableVariableJson(
      VariableDefinitionJson definition,
      @Nullable String value) {
    this.definition = definition;
    this.value = value;
  }

  /**
   * @return The value of the {@code definition} attribute
   */
  @JsonProperty("definition")
  @Override
  public VariableDefinitionJson definition() {
    return definition;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableJson#definition() definition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for definition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableJson withDefinition(VariableDefinitionJson value) {
    if (this.definition == value) return this;
    VariableDefinitionJson newValue = Objects.requireNonNull(value, "definition");
    return new ImmutableVariableJson(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableJson#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableJson withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableVariableJson(this.definition, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableJson
        && equalTo(0, (ImmutableVariableJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariableJson another) {
    return definition.equals(another.definition)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code definition}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + definition.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code VariableJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VariableJson{"
        + "definition=" + definition
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "VariableJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements VariableJson {
    @javax.annotation.Nullable VariableDefinitionJson definition;
    @javax.annotation.Nullable String value;
    @JsonProperty("definition")
    public void setDefinition(VariableDefinitionJson definition) {
      this.definition = definition;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public VariableDefinitionJson definition() { throw new UnsupportedOperationException(); }
    @Override
    public String value() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVariableJson fromJson(Json json) {
    ImmutableVariableJson.Builder builder = ImmutableVariableJson.builder();
    if (json.definition != null) {
      builder.definition(json.definition);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link VariableJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableJson instance
   */
  public static ImmutableVariableJson copyOf(VariableJson instance) {
    if (instance instanceof ImmutableVariableJson) {
      return (ImmutableVariableJson) instance;
    }
    return ImmutableVariableJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableJson ImmutableVariableJson}.
   * <pre>
   * ImmutableVariableJson.builder()
   *    .definition(zeenea.connector.matillion.etl.client.VariableDefinitionJson) // required {@link VariableJson#definition() definition}
   *    .value(String | null) // nullable {@link VariableJson#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableVariableJson builder
   */
  public static ImmutableVariableJson.Builder builder() {
    return new ImmutableVariableJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableJson ImmutableVariableJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DEFINITION = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable VariableDefinitionJson definition;
    private @javax.annotation.Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VariableJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VariableJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.definition(instance.definition());
      @Nullable String valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link VariableJson#definition() definition} attribute.
     * @param definition The value for definition 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("definition")
    public final Builder definition(VariableDefinitionJson definition) {
      this.definition = Objects.requireNonNull(definition, "definition");
      initBits &= ~INIT_BIT_DEFINITION;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableJson#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableJson ImmutableVariableJson}.
     * @return An immutable instance of VariableJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariableJson(definition, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DEFINITION) != 0) attributes.add("definition");
      return "Cannot build VariableJson, some of required attributes are not set " + attributes;
    }
  }
}
