package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableDefinitionJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableDefinitionJson.builder()}.
 */
@Generated(from = "VariableDefinitionJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVariableDefinitionJson
    implements VariableDefinitionJson {
  private final String name;
  private final String type;

  private ImmutableVariableDefinitionJson(String name, String type) {
    this.name = name;
    this.type = type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableDefinitionJson#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableDefinitionJson withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableVariableDefinitionJson(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableDefinitionJson#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableDefinitionJson withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableVariableDefinitionJson(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableDefinitionJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableDefinitionJson
        && equalTo(0, (ImmutableVariableDefinitionJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariableDefinitionJson another) {
    return name.equals(another.name)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VariableDefinitionJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VariableDefinitionJson{"
        + "name=" + name
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "VariableDefinitionJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements VariableDefinitionJson {
    @Nullable String name;
    @Nullable String type;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVariableDefinitionJson fromJson(Json json) {
    ImmutableVariableDefinitionJson.Builder builder = ImmutableVariableDefinitionJson.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link VariableDefinitionJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableDefinitionJson instance
   */
  public static ImmutableVariableDefinitionJson copyOf(VariableDefinitionJson instance) {
    if (instance instanceof ImmutableVariableDefinitionJson) {
      return (ImmutableVariableDefinitionJson) instance;
    }
    return ImmutableVariableDefinitionJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableDefinitionJson ImmutableVariableDefinitionJson}.
   * <pre>
   * ImmutableVariableDefinitionJson.builder()
   *    .name(String) // required {@link VariableDefinitionJson#name() name}
   *    .type(String) // required {@link VariableDefinitionJson#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableVariableDefinitionJson builder
   */
  public static ImmutableVariableDefinitionJson.Builder builder() {
    return new ImmutableVariableDefinitionJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableDefinitionJson ImmutableVariableDefinitionJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableDefinitionJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VariableDefinitionJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VariableDefinitionJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      this.type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link VariableDefinitionJson#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableDefinitionJson#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableDefinitionJson ImmutableVariableDefinitionJson}.
     * @return An immutable instance of VariableDefinitionJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableDefinitionJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariableDefinitionJson(name, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build VariableDefinitionJson, some of required attributes are not set " + attributes;
    }
  }
}
