package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransformationJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransformationJson.builder()}.
 */
@Generated(from = "TransformationJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTransformationJson
    implements TransformationJson {
  private final JobObjectJson jobObject;
  private final JobInfoJson info;

  private ImmutableTransformationJson(
      JobObjectJson jobObject,
      JobInfoJson info) {
    this.jobObject = jobObject;
    this.info = info;
  }

  /**
   * @return The value of the {@code jobObject} attribute
   */
  @JsonProperty("jobObject")
  @Override
  public JobObjectJson getJobObject() {
    return jobObject;
  }

  /**
   * @return The value of the {@code info} attribute
   */
  @JsonProperty("info")
  @Override
  public JobInfoJson getInfo() {
    return info;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransformationJson#getJobObject() jobObject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobObject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationJson withJobObject(JobObjectJson value) {
    if (this.jobObject == value) return this;
    JobObjectJson newValue = Objects.requireNonNull(value, "jobObject");
    return new ImmutableTransformationJson(newValue, this.info);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransformationJson#getInfo() info} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for info
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransformationJson withInfo(JobInfoJson value) {
    if (this.info == value) return this;
    JobInfoJson newValue = Objects.requireNonNull(value, "info");
    return new ImmutableTransformationJson(this.jobObject, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransformationJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransformationJson
        && equalTo(0, (ImmutableTransformationJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransformationJson another) {
    return jobObject.equals(another.jobObject)
        && info.equals(another.info);
  }

  /**
   * Computes a hash code from attributes: {@code jobObject}, {@code info}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + jobObject.hashCode();
    h += (h << 5) + info.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransformationJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TransformationJson{"
        + "jobObject=" + jobObject
        + ", info=" + info
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransformationJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TransformationJson {
    @Nullable JobObjectJson jobObject;
    @Nullable JobInfoJson info;
    @JsonProperty("jobObject")
    public void setJobObject(JobObjectJson jobObject) {
      this.jobObject = jobObject;
    }
    @JsonProperty("info")
    public void setInfo(JobInfoJson info) {
      this.info = info;
    }
    @Override
    public JobObjectJson getJobObject() { throw new UnsupportedOperationException(); }
    @Override
    public JobInfoJson getInfo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransformationJson fromJson(Json json) {
    ImmutableTransformationJson.Builder builder = ImmutableTransformationJson.builder();
    if (json.jobObject != null) {
      builder.jobObject(json.jobObject);
    }
    if (json.info != null) {
      builder.info(json.info);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TransformationJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransformationJson instance
   */
  public static ImmutableTransformationJson copyOf(TransformationJson instance) {
    if (instance instanceof ImmutableTransformationJson) {
      return (ImmutableTransformationJson) instance;
    }
    return ImmutableTransformationJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransformationJson ImmutableTransformationJson}.
   * <pre>
   * ImmutableTransformationJson.builder()
   *    .jobObject(zeenea.connector.matillion.etl.client.JobObjectJson) // required {@link TransformationJson#getJobObject() jobObject}
   *    .info(zeenea.connector.matillion.etl.client.JobInfoJson) // required {@link TransformationJson#getInfo() info}
   *    .build();
   * </pre>
   * @return A new ImmutableTransformationJson builder
   */
  public static ImmutableTransformationJson.Builder builder() {
    return new ImmutableTransformationJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransformationJson ImmutableTransformationJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransformationJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_JOB_OBJECT = 0x1L;
    private static final long INIT_BIT_INFO = 0x2L;
    private long initBits = 0x3L;

    private @Nullable JobObjectJson jobObject;
    private @Nullable JobInfoJson info;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransformationJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TransformationJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.jobObject(instance.getJobObject());
      this.info(instance.getInfo());
      return this;
    }

    /**
     * Initializes the value for the {@link TransformationJson#getJobObject() jobObject} attribute.
     * @param jobObject The value for jobObject 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jobObject")
    public final Builder jobObject(JobObjectJson jobObject) {
      this.jobObject = Objects.requireNonNull(jobObject, "jobObject");
      initBits &= ~INIT_BIT_JOB_OBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link TransformationJson#getInfo() info} attribute.
     * @param info The value for info 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("info")
    public final Builder info(JobInfoJson info) {
      this.info = Objects.requireNonNull(info, "info");
      initBits &= ~INIT_BIT_INFO;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransformationJson ImmutableTransformationJson}.
     * @return An immutable instance of TransformationJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransformationJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransformationJson(jobObject, info);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_JOB_OBJECT) != 0) attributes.add("jobObject");
      if ((initBits & INIT_BIT_INFO) != 0) attributes.add("info");
      return "Cannot build TransformationJson, some of required attributes are not set " + attributes;
    }
  }
}
