package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParameterJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParameterJson.builder()}.
 */
@Generated(from = "ParameterJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableParameterJson implements ParameterJson {
  private final int slot;
  private final String name;
  private final Map<String, ElementJson> elements;

  private ImmutableParameterJson(ImmutableParameterJson.Builder builder) {
    this.slot = builder.slot;
    this.name = builder.name;
    this.elements = builder.elementsIsSet()
        ? createUnmodifiableMap(false, false, builder.elements)
        : createUnmodifiableMap(true, false, ParameterJson.super.elements());
  }

  private ImmutableParameterJson(
      int slot,
      String name,
      Map<String, ElementJson> elements) {
    this.slot = slot;
    this.name = name;
    this.elements = elements;
  }

  /**
   * @return The value of the {@code slot} attribute
   */
  @JsonProperty("slot")
  @Override
  public int slot() {
    return slot;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty("elements")
  @Override
  public Map<String, ElementJson> elements() {
    return elements;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParameterJson#slot() slot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slot
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameterJson withSlot(int value) {
    if (this.slot == value) return this;
    return new ImmutableParameterJson(value, this.name, this.elements);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParameterJson#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameterJson withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableParameterJson(this.slot, newValue, this.elements);
  }

  /**
   * Copy the current immutable object by replacing the {@link ParameterJson#elements() elements} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the elements map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameterJson withElements(Map<String, ? extends ElementJson> entries) {
    if (this.elements == entries) return this;
    Map<String, ElementJson> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableParameterJson(this.slot, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameterJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameterJson
        && equalTo(0, (ImmutableParameterJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableParameterJson another) {
    return slot == another.slot
        && name.equals(another.name)
        && elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code slot}, {@code name}, {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + slot;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ParameterJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ParameterJson{"
        + "slot=" + slot
        + ", name=" + name
        + ", elements=" + elements
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ParameterJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ParameterJson {
    int slot;
    boolean slotIsSet;
    @Nullable String name;
    @Nullable Map<String, ElementJson> elements = Collections.emptyMap();
    boolean elementsIsSet;
    @JsonProperty("slot")
    public void setSlot(int slot) {
      this.slot = slot;
      this.slotIsSet = true;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("elements")
    public void setElements(Map<String, ElementJson> elements) {
      this.elements = elements;
      this.elementsIsSet = null != elements;
    }
    @Override
    public int slot() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ElementJson> elements() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableParameterJson fromJson(Json json) {
    ImmutableParameterJson.Builder builder = ImmutableParameterJson.builder();
    if (json.slotIsSet) {
      builder.slot(json.slot);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.elementsIsSet) {
      builder.putAllElements(json.elements);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ParameterJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParameterJson instance
   */
  public static ImmutableParameterJson copyOf(ParameterJson instance) {
    if (instance instanceof ImmutableParameterJson) {
      return (ImmutableParameterJson) instance;
    }
    return ImmutableParameterJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParameterJson ImmutableParameterJson}.
   * <pre>
   * ImmutableParameterJson.builder()
   *    .slot(int) // required {@link ParameterJson#slot() slot}
   *    .name(String) // required {@link ParameterJson#name() name}
   *    .putElements|putAllElements(String =&gt; zeenea.connector.matillion.etl.client.ElementJson) // {@link ParameterJson#elements() elements} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableParameterJson builder
   */
  public static ImmutableParameterJson.Builder builder() {
    return new ImmutableParameterJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParameterJson ImmutableParameterJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParameterJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SLOT = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long OPT_BIT_ELEMENTS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private int slot;
    private @Nullable String name;
    private Map<String, ElementJson> elements = new LinkedHashMap<String, ElementJson>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParameterJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ParameterJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.slot(instance.slot());
      this.name(instance.name());
      putAllElements(instance.elements());
      return this;
    }

    /**
     * Initializes the value for the {@link ParameterJson#slot() slot} attribute.
     * @param slot The value for slot 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("slot")
    public final Builder slot(int slot) {
      this.slot = slot;
      initBits &= ~INIT_BIT_SLOT;
      return this;
    }

    /**
     * Initializes the value for the {@link ParameterJson#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link ParameterJson#elements() elements} map.
     * @param key The key in the elements map
     * @param value The associated value in the elements map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putElements(String key, ElementJson value) {
      this.elements.put(
          Objects.requireNonNull(key, "elements key"),
          Objects.requireNonNull(value, value == null ? "elements value for key: " + key : null));
      optBits |= OPT_BIT_ELEMENTS;
      return this;
    }

    /**
     * Put one entry to the {@link ParameterJson#elements() elements} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putElements(Map.Entry<String, ? extends ElementJson> entry) {
      String k = entry.getKey();
      ElementJson v = entry.getValue();
      this.elements.put(
          Objects.requireNonNull(k, "elements key"),
          Objects.requireNonNull(v, v == null ? "elements value for key: " + k : null));
      optBits |= OPT_BIT_ELEMENTS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ParameterJson#elements() elements} map. Nulls are not permitted
     * @param entries The entries that will be added to the elements map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("elements")
    public final Builder elements(Map<String, ? extends ElementJson> entries) {
      this.elements.clear();
      optBits |= OPT_BIT_ELEMENTS;
      return putAllElements(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ParameterJson#elements() elements} map. Nulls are not permitted
     * @param entries The entries that will be added to the elements map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllElements(Map<String, ? extends ElementJson> entries) {
      for (Map.Entry<String, ? extends ElementJson> e : entries.entrySet()) {
        String k = e.getKey();
        ElementJson v = e.getValue();
        this.elements.put(
            Objects.requireNonNull(k, "elements key"),
            Objects.requireNonNull(v, v == null ? "elements value for key: " + k : null));
      }
      optBits |= OPT_BIT_ELEMENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableParameterJson ImmutableParameterJson}.
     * @return An immutable instance of ParameterJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParameterJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParameterJson(this);
    }

    private boolean elementsIsSet() {
      return (optBits & OPT_BIT_ELEMENTS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SLOT) != 0) attributes.add("slot");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ParameterJson, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
