package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link JobObjectJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobObjectJson.builder()}.
 */
@Generated(from = "JobObjectJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableJobObjectJson implements JobObjectJson {
  private final long created;
  private final long timestamp;
  @NotNull
  private final Map<String, ComponentJson> components;
  private final Map<String, VariableJson> variables;

  private ImmutableJobObjectJson(ImmutableJobObjectJson.Builder builder) {
    this.created = builder.created;
    this.timestamp = builder.timestamp;
    if (builder.componentsIsSet()) {
      initShim.components(Map.copyOf(builder.components));
    }
    if (builder.variablesIsSet()) {
      initShim.variables(createUnmodifiableMap(false, false, builder.variables));
    }
    this.components = initShim.getComponents();
    this.variables = initShim.getVariables();
    this.initShim = null;
  }

  private ImmutableJobObjectJson(
      long created,
      long timestamp,
      Map<String, ComponentJson> components,
      Map<String, VariableJson> variables) {
    this.created = created;
    this.timestamp = timestamp;
    this.components = components;
    this.variables = variables;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "JobObjectJson", generator = "Immutables")
  private final class InitShim {
    private byte componentsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, ComponentJson> components;

    Map<String, ComponentJson> getComponents() {
      if (componentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (componentsBuildStage == STAGE_UNINITIALIZED) {
        componentsBuildStage = STAGE_INITIALIZING;
        this.components = Map.copyOf(getComponentsInitialize());
        componentsBuildStage = STAGE_INITIALIZED;
      }
      return this.components;
    }

    void components(Map<String, ComponentJson> components) {
      this.components = components;
      componentsBuildStage = STAGE_INITIALIZED;
    }

    private byte variablesBuildStage = STAGE_UNINITIALIZED;
    private Map<String, VariableJson> variables;

    Map<String, VariableJson> getVariables() {
      if (variablesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (variablesBuildStage == STAGE_UNINITIALIZED) {
        variablesBuildStage = STAGE_INITIALIZING;
        this.variables = createUnmodifiableMap(false, false, getVariablesInitialize());
        variablesBuildStage = STAGE_INITIALIZED;
      }
      return this.variables;
    }

    void variables(Map<String, VariableJson> variables) {
      this.variables = variables;
      variablesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (componentsBuildStage == STAGE_INITIALIZING) attributes.add("components");
      if (variablesBuildStage == STAGE_INITIALIZING) attributes.add("variables");
      return "Cannot build JobObjectJson, attribute initializers form cycle " + attributes;
    }
  }

  private Map<String, ComponentJson> getComponentsInitialize() {
    return JobObjectJson.super.getComponents();
  }

  private Map<String, VariableJson> getVariablesInitialize() {
    return JobObjectJson.super.getVariables();
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public long getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("timestamp")
  @Override
  public long getTimestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @JsonProperty("components")
  @NotNull
  @Override
  public Map<String, ComponentJson> getComponents() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getComponents()
        : this.components;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @JsonProperty("variables")
  @Override
  public Map<String, VariableJson> getVariables() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVariables()
        : this.variables;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobObjectJson#getCreated() created} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobObjectJson withCreated(long value) {
    if (this.created == value) return this;
    return new ImmutableJobObjectJson(value, this.timestamp, this.components, this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobObjectJson#getTimestamp() timestamp} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobObjectJson withTimestamp(long value) {
    if (this.timestamp == value) return this;
    return new ImmutableJobObjectJson(this.created, value, this.components, this.variables);
  }

  /**
   * Copy the current immutable object by replacing the {@link JobObjectJson#getComponents() components} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the components map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobObjectJson withComponents(Map<String, ? extends ComponentJson> entries) {
    if (this.components == entries) return this;
    Map<String, ComponentJson> newValue = Map.copyOf(entries);
    return new ImmutableJobObjectJson(this.created, this.timestamp, newValue, this.variables);
  }

  /**
   * Copy the current immutable object by replacing the {@link JobObjectJson#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobObjectJson withVariables(Map<String, ? extends VariableJson> entries) {
    if (this.variables == entries) return this;
    Map<String, VariableJson> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableJobObjectJson(this.created, this.timestamp, this.components, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobObjectJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobObjectJson
        && equalTo(0, (ImmutableJobObjectJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobObjectJson another) {
    return created == another.created
        && timestamp == another.timestamp
        && components.equals(another.components)
        && variables.equals(another.variables);
  }

  /**
   * Computes a hash code from attributes: {@code created}, {@code timestamp}, {@code components}, {@code variables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(created);
    h += (h << 5) + Long.hashCode(timestamp);
    h += (h << 5) + components.hashCode();
    h += (h << 5) + variables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JobObjectJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobObjectJson{"
        + "created=" + created
        + ", timestamp=" + timestamp
        + ", components=" + components
        + ", variables=" + variables
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JobObjectJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JobObjectJson {
    long created;
    boolean createdIsSet;
    long timestamp;
    boolean timestampIsSet;
    @Nullable Map<String, ComponentJson> components = Map.of();
    boolean componentsIsSet;
    @Nullable Map<String, VariableJson> variables = Collections.emptyMap();
    boolean variablesIsSet;
    @JsonProperty("created")
    public void setCreated(long created) {
      this.created = created;
      this.createdIsSet = true;
    }
    @JsonProperty("timestamp")
    public void setTimestamp(long timestamp) {
      this.timestamp = timestamp;
      this.timestampIsSet = true;
    }
    @JsonProperty("components")
    public void setComponents(Map<String, ComponentJson> components) {
      this.components = components;
      this.componentsIsSet = null != components;
    }
    @JsonProperty("variables")
    public void setVariables(Map<String, VariableJson> variables) {
      this.variables = variables;
      this.variablesIsSet = null != variables;
    }
    @Override
    public long getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public long getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ComponentJson> getComponents() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, VariableJson> getVariables() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJobObjectJson fromJson(Json json) {
    ImmutableJobObjectJson.Builder builder = ImmutableJobObjectJson.builder();
    if (json.createdIsSet) {
      builder.created(json.created);
    }
    if (json.timestampIsSet) {
      builder.timestamp(json.timestamp);
    }
    if (json.componentsIsSet) {
      builder.putAllComponents(json.components);
    }
    if (json.variablesIsSet) {
      builder.putAllVariables(json.variables);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JobObjectJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobObjectJson instance
   */
  public static ImmutableJobObjectJson copyOf(JobObjectJson instance) {
    if (instance instanceof ImmutableJobObjectJson) {
      return (ImmutableJobObjectJson) instance;
    }
    return ImmutableJobObjectJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobObjectJson ImmutableJobObjectJson}.
   * <pre>
   * ImmutableJobObjectJson.builder()
   *    .created(long) // required {@link JobObjectJson#getCreated() created}
   *    .timestamp(long) // required {@link JobObjectJson#getTimestamp() timestamp}
   *    .putComponents|putAllComponents(String =&gt; zeenea.connector.matillion.etl.client.ComponentJson) // {@link JobObjectJson#getComponents() components} mappings
   *    .putVariables|putAllVariables(String =&gt; zeenea.connector.matillion.etl.client.VariableJson) // {@link JobObjectJson#getVariables() variables} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableJobObjectJson builder
   */
  public static ImmutableJobObjectJson.Builder builder() {
    return new ImmutableJobObjectJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobObjectJson ImmutableJobObjectJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobObjectJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CREATED = 0x1L;
    private static final long INIT_BIT_TIMESTAMP = 0x2L;
    private static final long OPT_BIT_COMPONENTS = 0x1L;
    private static final long OPT_BIT_VARIABLES = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private long created;
    private long timestamp;
    private Map<String, ComponentJson> components = new LinkedHashMap<String, ComponentJson>();
    private Map<String, VariableJson> variables = new LinkedHashMap<String, VariableJson>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobObjectJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobObjectJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.created(instance.getCreated());
      this.timestamp(instance.getTimestamp());
      putAllComponents(instance.getComponents());
      putAllVariables(instance.getVariables());
      return this;
    }

    /**
     * Initializes the value for the {@link JobObjectJson#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(long created) {
      this.created = created;
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link JobObjectJson#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(long timestamp) {
      this.timestamp = timestamp;
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Put one entry to the {@link JobObjectJson#getComponents() components} map.
     * @param key The key in the components map
     * @param value The associated value in the components map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putComponents(String key, ComponentJson value) {
      this.components.put(
          Objects.requireNonNull(key, "components key"),
          Objects.requireNonNull(value, value == null ? "components value for key: " + key : null));
      optBits |= OPT_BIT_COMPONENTS;
      return this;
    }

    /**
     * Put one entry to the {@link JobObjectJson#getComponents() components} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putComponents(Map.Entry<String, ? extends ComponentJson> entry) {
      String k = entry.getKey();
      ComponentJson v = entry.getValue();
      this.components.put(
          Objects.requireNonNull(k, "components key"),
          Objects.requireNonNull(v, v == null ? "components value for key: " + k : null));
      optBits |= OPT_BIT_COMPONENTS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JobObjectJson#getComponents() components} map. Nulls are not permitted
     * @param entries The entries that will be added to the components map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("components")
    public final Builder components(Map<String, ? extends ComponentJson> entries) {
      this.components.clear();
      optBits |= OPT_BIT_COMPONENTS;
      return putAllComponents(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JobObjectJson#getComponents() components} map. Nulls are not permitted
     * @param entries The entries that will be added to the components map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllComponents(Map<String, ? extends ComponentJson> entries) {
      for (Map.Entry<String, ? extends ComponentJson> e : entries.entrySet()) {
        String k = e.getKey();
        ComponentJson v = e.getValue();
        this.components.put(
            Objects.requireNonNull(k, "components key"),
            Objects.requireNonNull(v, v == null ? "components value for key: " + k : null));
      }
      optBits |= OPT_BIT_COMPONENTS;
      return this;
    }

    /**
     * Put one entry to the {@link JobObjectJson#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(@Nullable String key, @Nullable VariableJson value) {
      this.variables.put(key, value);
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Put one entry to the {@link JobObjectJson#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(Map.Entry<String, ? extends VariableJson> entry) {
      String k = entry.getKey();
      VariableJson v = entry.getValue();
      this.variables.put(k, v);
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JobObjectJson#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("variables")
    public final Builder variables(Map<String, ? extends VariableJson> entries) {
      this.variables.clear();
      optBits |= OPT_BIT_VARIABLES;
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JobObjectJson#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends VariableJson> entries) {
      for (Map.Entry<String, ? extends VariableJson> e : entries.entrySet()) {
        String k = e.getKey();
        VariableJson v = e.getValue();
        this.variables.put(k, v);
      }
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobObjectJson ImmutableJobObjectJson}.
     * @return An immutable instance of JobObjectJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobObjectJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJobObjectJson(this);
    }

    private boolean componentsIsSet() {
      return (optBits & OPT_BIT_COMPONENTS) != 0;
    }

    private boolean variablesIsSet() {
      return (optBits & OPT_BIT_VARIABLES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      return "Cannot build JobObjectJson, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
