package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link JobInfoJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobInfoJson.builder()}.
 */
@Generated(from = "JobInfoJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableJobInfoJson implements JobInfoJson {
  @NotNull
  private final String name;
  private final @Nullable Long id;
  private final @Nullable String description;
  private final @Nullable String type;
  private final @Nullable String tag;

  private ImmutableJobInfoJson(
      String name,
      @Nullable Long id,
      @Nullable String description,
      @Nullable String type,
      @Nullable String tag) {
    this.name = name;
    this.id = id;
    this.description = description;
    this.type = type;
    this.tag = tag;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @NotNull
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable Long id() {
    return id;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String description() {
    return description;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code tag} attribute
   */
  @JsonProperty("tag")
  @Override
  public @Nullable String tag() {
    return tag;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfoJson#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfoJson withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableJobInfoJson(newValue, this.id, this.description, this.type, this.tag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfoJson#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfoJson withId(@Nullable Long value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableJobInfoJson(this.name, value, this.description, this.type, this.tag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfoJson#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfoJson withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableJobInfoJson(this.name, this.id, value, this.type, this.tag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfoJson#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfoJson withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableJobInfoJson(this.name, this.id, this.description, value, this.tag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobInfoJson#tag() tag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tag (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobInfoJson withTag(@Nullable String value) {
    if (Objects.equals(this.tag, value)) return this;
    return new ImmutableJobInfoJson(this.name, this.id, this.description, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobInfoJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobInfoJson
        && equalTo(0, (ImmutableJobInfoJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobInfoJson another) {
    return name.equals(another.name)
        && Objects.equals(id, another.id)
        && Objects.equals(description, another.description)
        && Objects.equals(type, another.type)
        && Objects.equals(tag, another.tag);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}, {@code description}, {@code type}, {@code tag}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(tag);
    return h;
  }

  /**
   * Prints the immutable value {@code JobInfoJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobInfoJson{"
        + "name=" + name
        + ", id=" + id
        + ", description=" + description
        + ", type=" + type
        + ", tag=" + tag
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JobInfoJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JobInfoJson {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable Long id;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String tag;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("id")
    public void setId(@Nullable Long id) {
      this.id = id;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("tag")
    public void setTag(@Nullable String tag) {
      this.tag = tag;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public Long id() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String tag() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJobInfoJson fromJson(Json json) {
    ImmutableJobInfoJson.Builder builder = ImmutableJobInfoJson.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.tag != null) {
      builder.tag(json.tag);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JobInfoJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobInfoJson instance
   */
  public static ImmutableJobInfoJson copyOf(JobInfoJson instance) {
    if (instance instanceof ImmutableJobInfoJson) {
      return (ImmutableJobInfoJson) instance;
    }
    return ImmutableJobInfoJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobInfoJson ImmutableJobInfoJson}.
   * <pre>
   * ImmutableJobInfoJson.builder()
   *    .name(String) // required {@link JobInfoJson#name() name}
   *    .id(Long | null) // nullable {@link JobInfoJson#id() id}
   *    .description(String | null) // nullable {@link JobInfoJson#description() description}
   *    .type(String | null) // nullable {@link JobInfoJson#type() type}
   *    .tag(String | null) // nullable {@link JobInfoJson#tag() tag}
   *    .build();
   * </pre>
   * @return A new ImmutableJobInfoJson builder
   */
  public static ImmutableJobInfoJson.Builder builder() {
    return new ImmutableJobInfoJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobInfoJson ImmutableJobInfoJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobInfoJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable Long id;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String tag;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobInfoJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobInfoJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      @Nullable Long idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String descriptionValue = instance.description();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String tagValue = instance.tag();
      if (tagValue != null) {
        tag(tagValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfoJson#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfoJson#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable Long id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfoJson#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfoJson#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link JobInfoJson#tag() tag} attribute.
     * @param tag The value for tag (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tag")
    public final Builder tag(@Nullable String tag) {
      this.tag = tag;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobInfoJson ImmutableJobInfoJson}.
     * @return An immutable instance of JobInfoJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobInfoJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJobInfoJson(name, id, description, type, tag);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build JobInfoJson, some of required attributes are not set " + attributes;
    }
  }
}
