package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExportJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExportJson.builder()}.
 */
@Generated(from = "ExportJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableExportJson<T> implements ExportJson<T> {
  private final List<T> objects;
  private final String version;
  private final String environment;

  private ImmutableExportJson(ImmutableExportJson.Builder<T> builder) {
    this.version = builder.version;
    this.environment = builder.environment;
    this.objects = builder.objectsIsSet()
        ? List.copyOf(builder.objects)
        : ExportJson.super.getObjects() instanceof Collection<?>
       ? List.copyOf((Collection<? extends T>) ExportJson.super.getObjects())
       : StreamSupport.stream(ExportJson.super.getObjects().spliterator(), false)
             .collect(Collectors.toUnmodifiableList());
  }

  private ImmutableExportJson(List<T> objects, String version, String environment) {
    this.objects = objects;
    this.version = version;
    this.environment = environment;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @JsonProperty("objects")
  @Override
  public List<T> getObjects() {
    return objects;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }

  /**
   * @return The value of the {@code environment} attribute
   */
  @JsonProperty("environment")
  @Override
  public String environment() {
    return environment;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExportJson#getObjects() objects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableExportJson<T> withObjects(T... elements) {
    List<T> newValue = List.of(elements);
    return new ImmutableExportJson<>(newValue, this.version, this.environment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExportJson#getObjects() objects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of objects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExportJson<T> withObjects(Iterable<? extends T> elements) {
    if (this.objects == elements) return this;
    List<T> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends T>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableExportJson<>(newValue, this.version, this.environment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExportJson#version() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExportJson<T> withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableExportJson<>(this.objects, newValue, this.environment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExportJson#environment() environment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for environment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExportJson<T> withEnvironment(String value) {
    String newValue = Objects.requireNonNull(value, "environment");
    if (this.environment.equals(newValue)) return this;
    return new ImmutableExportJson<>(this.objects, this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExportJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExportJson<?>
        && equalTo(0, (ImmutableExportJson<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableExportJson<?> another) {
    return objects.equals(another.objects)
        && version.equals(another.version)
        && environment.equals(another.environment);
  }

  /**
   * Computes a hash code from attributes: {@code objects}, {@code version}, {@code environment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + objects.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + environment.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExportJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExportJson{"
        + "objects=" + objects
        + ", version=" + version
        + ", environment=" + environment
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ExportJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T> implements ExportJson<T> {
    @Nullable List<T> objects = List.of();
    boolean objectsIsSet;
    @Nullable String version;
    @Nullable String environment;
    @JsonProperty("objects")
    public void setObjects(List<T> objects) {
      this.objects = objects;
      this.objectsIsSet = null != objects;
    }
    @JsonProperty("version")
    public void setVersion(String version) {
      this.version = version;
    }
    @JsonProperty("environment")
    public void setEnvironment(String environment) {
      this.environment = environment;
    }
    @Override
    public List<T> getObjects() { throw new UnsupportedOperationException(); }
    @Override
    public String version() { throw new UnsupportedOperationException(); }
    @Override
    public String environment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <T> ImmutableExportJson<T> fromJson(Json<T> json) {
    ImmutableExportJson.Builder<T> builder = ImmutableExportJson.<T>builder();
    if (json.objectsIsSet) {
      builder.addAllObjects(json.objects);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    if (json.environment != null) {
      builder.environment(json.environment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ExportJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ExportJson instance
   */
  public static <T> ImmutableExportJson<T> copyOf(ExportJson<T> instance) {
    if (instance instanceof ImmutableExportJson<?>) {
      return (ImmutableExportJson<T>) instance;
    }
    return ImmutableExportJson.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExportJson ImmutableExportJson}.
   * <pre>
   * ImmutableExportJson.&amp;lt;T&amp;gt;builder()
   *    .addObjects|addAllObjects(T) // {@link ExportJson#getObjects() objects} elements
   *    .version(String) // required {@link ExportJson#version() version}
   *    .environment(String) // required {@link ExportJson#environment() environment}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableExportJson builder
   */
  public static <T> ImmutableExportJson.Builder<T> builder() {
    return new ImmutableExportJson.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableExportJson ImmutableExportJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExportJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_ENVIRONMENT = 0x2L;
    private static final long OPT_BIT_OBJECTS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private List<T> objects = new ArrayList<T>();
    private @Nullable String version;
    private @Nullable String environment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExportJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(ExportJson<T> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllObjects(instance.getObjects());
      this.version(instance.version());
      this.environment(instance.environment());
      return this;
    }

    /**
     * Adds one element to {@link ExportJson#getObjects() objects} list.
     * @param element A objects element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addObjects(T element) {
      this.objects.add(Objects.requireNonNull(element, "objects element"));
      optBits |= OPT_BIT_OBJECTS;
      return this;
    }

    /**
     * Adds elements to {@link ExportJson#getObjects() objects} list.
     * @param elements An array of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addObjects(T... elements) {
      for (T element : elements) {
        this.objects.add(Objects.requireNonNull(element, "objects element"));
      }
      optBits |= OPT_BIT_OBJECTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExportJson#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("objects")
    public final Builder<T> objects(Iterable<? extends T> elements) {
      this.objects.clear();
      return addAllObjects(elements);
    }

    /**
     * Adds elements to {@link ExportJson#getObjects() objects} list.
     * @param elements An iterable of objects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllObjects(Iterable<? extends T> elements) {
      for (T element : elements) {
        this.objects.add(Objects.requireNonNull(element, "objects element"));
      }
      optBits |= OPT_BIT_OBJECTS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExportJson#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder<T> version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link ExportJson#environment() environment} attribute.
     * @param environment The value for environment 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment")
    public final Builder<T> environment(String environment) {
      this.environment = Objects.requireNonNull(environment, "environment");
      initBits &= ~INIT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExportJson ImmutableExportJson}.
     * @return An immutable instance of ExportJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExportJson<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExportJson<T>(this);
    }

    private boolean objectsIsSet() {
      return (optBits & OPT_BIT_OBJECTS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
      return "Cannot build ExportJson, some of required attributes are not set " + attributes;
    }
  }
}
