package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link EnvironmentJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEnvironmentJson.builder()}.
 */
@Generated(from = "EnvironmentJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableEnvironmentJson implements EnvironmentJson {
  private final @Nullable String name;
  private final @Nullable String credentialsName;
  private final @Nullable String gcCredentialsName;
  private final @Nullable String azureCredentialsName;
  private final @Nullable String schema;
  private final @Nullable Boolean encrypted;
  private final @Nullable String url;
  private final @Nullable String port;
  private final @Nullable String database;
  private final @Nullable String driver;
  private final @Nullable String user;
  private final @Nullable String role;
  private final Map<String, String> variables;
  private final @Nullable String defaultStorageLocation;
  private final @Nullable Integer concurrentConnections;
  private final Map<String, String> connectionOptions;
  private final boolean defaultEnvironment;

  private ImmutableEnvironmentJson(ImmutableEnvironmentJson.Builder builder) {
    this.name = builder.name;
    this.credentialsName = builder.credentialsName;
    this.gcCredentialsName = builder.gcCredentialsName;
    this.azureCredentialsName = builder.azureCredentialsName;
    this.schema = builder.schema;
    this.encrypted = builder.encrypted;
    this.url = builder.url;
    this.port = builder.port;
    this.database = builder.database;
    this.driver = builder.driver;
    this.user = builder.user;
    this.role = builder.role;
    this.defaultStorageLocation = builder.defaultStorageLocation;
    this.concurrentConnections = builder.concurrentConnections;
    if (builder.variablesIsSet()) {
      initShim.variables(createUnmodifiableMap(false, false, builder.variables));
    }
    if (builder.connectionOptionsIsSet()) {
      initShim.connectionOptions(createUnmodifiableMap(false, false, builder.connectionOptions));
    }
    if (builder.defaultEnvironmentIsSet()) {
      initShim.defaultEnvironment(builder.defaultEnvironment);
    }
    this.variables = initShim.getVariables();
    this.connectionOptions = initShim.getConnectionOptions();
    this.defaultEnvironment = initShim.getDefaultEnvironment();
    this.initShim = null;
  }

  private ImmutableEnvironmentJson(
      @Nullable String name,
      @Nullable String credentialsName,
      @Nullable String gcCredentialsName,
      @Nullable String azureCredentialsName,
      @Nullable String schema,
      @Nullable Boolean encrypted,
      @Nullable String url,
      @Nullable String port,
      @Nullable String database,
      @Nullable String driver,
      @Nullable String user,
      @Nullable String role,
      Map<String, String> variables,
      @Nullable String defaultStorageLocation,
      @Nullable Integer concurrentConnections,
      Map<String, String> connectionOptions,
      boolean defaultEnvironment) {
    this.name = name;
    this.credentialsName = credentialsName;
    this.gcCredentialsName = gcCredentialsName;
    this.azureCredentialsName = azureCredentialsName;
    this.schema = schema;
    this.encrypted = encrypted;
    this.url = url;
    this.port = port;
    this.database = database;
    this.driver = driver;
    this.user = user;
    this.role = role;
    this.variables = variables;
    this.defaultStorageLocation = defaultStorageLocation;
    this.concurrentConnections = concurrentConnections;
    this.connectionOptions = connectionOptions;
    this.defaultEnvironment = defaultEnvironment;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "EnvironmentJson", generator = "Immutables")
  private final class InitShim {
    private byte variablesBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> variables;

    Map<String, String> getVariables() {
      if (variablesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (variablesBuildStage == STAGE_UNINITIALIZED) {
        variablesBuildStage = STAGE_INITIALIZING;
        this.variables = createUnmodifiableMap(false, false, getVariablesInitialize());
        variablesBuildStage = STAGE_INITIALIZED;
      }
      return this.variables;
    }

    void variables(Map<String, String> variables) {
      this.variables = variables;
      variablesBuildStage = STAGE_INITIALIZED;
    }

    private byte connectionOptionsBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> connectionOptions;

    Map<String, String> getConnectionOptions() {
      if (connectionOptionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (connectionOptionsBuildStage == STAGE_UNINITIALIZED) {
        connectionOptionsBuildStage = STAGE_INITIALIZING;
        this.connectionOptions = createUnmodifiableMap(true, false, getConnectionOptionsInitialize());
        connectionOptionsBuildStage = STAGE_INITIALIZED;
      }
      return this.connectionOptions;
    }

    void connectionOptions(Map<String, String> connectionOptions) {
      this.connectionOptions = connectionOptions;
      connectionOptionsBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultEnvironmentBuildStage = STAGE_UNINITIALIZED;
    private boolean defaultEnvironment;

    boolean getDefaultEnvironment() {
      if (defaultEnvironmentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultEnvironmentBuildStage == STAGE_UNINITIALIZED) {
        defaultEnvironmentBuildStage = STAGE_INITIALIZING;
        this.defaultEnvironment = getDefaultEnvironmentInitialize();
        defaultEnvironmentBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultEnvironment;
    }

    void defaultEnvironment(boolean defaultEnvironment) {
      this.defaultEnvironment = defaultEnvironment;
      defaultEnvironmentBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (variablesBuildStage == STAGE_INITIALIZING) attributes.add("variables");
      if (connectionOptionsBuildStage == STAGE_INITIALIZING) attributes.add("connectionOptions");
      if (defaultEnvironmentBuildStage == STAGE_INITIALIZING) attributes.add("defaultEnvironment");
      return "Cannot build EnvironmentJson, attribute initializers form cycle " + attributes;
    }
  }

  private Map<String, String> getVariablesInitialize() {
    return EnvironmentJson.super.getVariables();
  }

  private Map<String, String> getConnectionOptionsInitialize() {
    return EnvironmentJson.super.getConnectionOptions();
  }

  private boolean getDefaultEnvironmentInitialize() {
    return EnvironmentJson.super.getDefaultEnvironment();
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code credentialsName} attribute
   */
  @JsonProperty("credentialsName")
  @Override
  public @Nullable String getCredentialsName() {
    return credentialsName;
  }

  /**
   * @return The value of the {@code gcCredentialsName} attribute
   */
  @JsonProperty("gcCredentialsName")
  @Override
  public @Nullable String getGcCredentialsName() {
    return gcCredentialsName;
  }

  /**
   * @return The value of the {@code azureCredentialsName} attribute
   */
  @JsonProperty("azureCredentialsName")
  @Override
  public @Nullable String getAzureCredentialsName() {
    return azureCredentialsName;
  }

  /**
   * @return The value of the {@code schema} attribute
   */
  @JsonProperty("schema")
  @Override
  public @Nullable String getSchema() {
    return schema;
  }

  /**
   * @return The value of the {@code encrypted} attribute
   */
  @JsonProperty("encrypted")
  @Override
  public @Nullable Boolean getEncrypted() {
    return encrypted;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty("url")
  @Override
  public @Nullable String getUrl() {
    return url;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public @Nullable String getPort() {
    return port;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public @Nullable String getDatabase() {
    return database;
  }

  /**
   * @return The value of the {@code driver} attribute
   */
  @JsonProperty("driver")
  @Override
  public @Nullable String getDriver() {
    return driver;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public @Nullable String getUser() {
    return user;
  }

  /**
   * @return The value of the {@code role} attribute
   */
  @JsonProperty("role")
  @Override
  public @Nullable String getRole() {
    return role;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @JsonProperty("variables")
  @Override
  public Map<String, String> getVariables() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getVariables()
        : this.variables;
  }

  /**
   * @return The value of the {@code defaultStorageLocation} attribute
   */
  @JsonProperty("defaultStorageLocation")
  @Override
  public @Nullable String getDefaultStorageLocation() {
    return defaultStorageLocation;
  }

  /**
   * @return The value of the {@code concurrentConnections} attribute
   */
  @JsonProperty("concurrentConnections")
  @Override
  public @Nullable Integer getConcurrentConnections() {
    return concurrentConnections;
  }

  /**
   * @return The value of the {@code connectionOptions} attribute
   */
  @JsonProperty("connectionOptions")
  @Override
  public Map<String, String> getConnectionOptions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConnectionOptions()
        : this.connectionOptions;
  }

  /**
   * @return The value of the {@code defaultEnvironment} attribute
   */
  @JsonProperty("defaultEnvironment")
  @Override
  public boolean getDefaultEnvironment() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaultEnvironment()
        : this.defaultEnvironment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableEnvironmentJson(
        value,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getCredentialsName() credentialsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for credentialsName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withCredentialsName(@Nullable String value) {
    if (Objects.equals(this.credentialsName, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        value,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getGcCredentialsName() gcCredentialsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gcCredentialsName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withGcCredentialsName(@Nullable String value) {
    if (Objects.equals(this.gcCredentialsName, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        value,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getAzureCredentialsName() azureCredentialsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for azureCredentialsName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withAzureCredentialsName(@Nullable String value) {
    if (Objects.equals(this.azureCredentialsName, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        value,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getSchema() schema} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schema (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withSchema(@Nullable String value) {
    if (Objects.equals(this.schema, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        value,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getEncrypted() encrypted} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for encrypted (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withEncrypted(@Nullable Boolean value) {
    if (Objects.equals(this.encrypted, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        value,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getUrl() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withUrl(@Nullable String value) {
    if (Objects.equals(this.url, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        value,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getPort() port} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withPort(@Nullable String value) {
    if (Objects.equals(this.port, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        value,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withDatabase(@Nullable String value) {
    if (Objects.equals(this.database, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        value,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getDriver() driver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driver (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withDriver(@Nullable String value) {
    if (Objects.equals(this.driver, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        value,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getUser() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withUser(@Nullable String value) {
    if (Objects.equals(this.user, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        value,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getRole() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        value,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by replacing the {@link EnvironmentJson#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEnvironmentJson withVariables(Map<String, ? extends String> entries) {
    if (this.variables == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        newValue,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getDefaultStorageLocation() defaultStorageLocation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultStorageLocation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withDefaultStorageLocation(@Nullable String value) {
    if (Objects.equals(this.defaultStorageLocation, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        value,
        this.concurrentConnections,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getConcurrentConnections() concurrentConnections} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for concurrentConnections (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withConcurrentConnections(@Nullable Integer value) {
    if (Objects.equals(this.concurrentConnections, value)) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        value,
        this.connectionOptions,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by replacing the {@link EnvironmentJson#getConnectionOptions() connectionOptions} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the connectionOptions map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEnvironmentJson withConnectionOptions(Map<String, ? extends String> entries) {
    if (this.connectionOptions == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        newValue,
        this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnvironmentJson#getDefaultEnvironment() defaultEnvironment} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultEnvironment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnvironmentJson withDefaultEnvironment(boolean value) {
    if (this.defaultEnvironment == value) return this;
    return new ImmutableEnvironmentJson(
        this.name,
        this.credentialsName,
        this.gcCredentialsName,
        this.azureCredentialsName,
        this.schema,
        this.encrypted,
        this.url,
        this.port,
        this.database,
        this.driver,
        this.user,
        this.role,
        this.variables,
        this.defaultStorageLocation,
        this.concurrentConnections,
        this.connectionOptions,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnvironmentJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnvironmentJson
        && equalTo(0, (ImmutableEnvironmentJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableEnvironmentJson another) {
    return Objects.equals(name, another.name)
        && Objects.equals(credentialsName, another.credentialsName)
        && Objects.equals(gcCredentialsName, another.gcCredentialsName)
        && Objects.equals(azureCredentialsName, another.azureCredentialsName)
        && Objects.equals(schema, another.schema)
        && Objects.equals(encrypted, another.encrypted)
        && Objects.equals(url, another.url)
        && Objects.equals(port, another.port)
        && Objects.equals(database, another.database)
        && Objects.equals(driver, another.driver)
        && Objects.equals(user, another.user)
        && Objects.equals(role, another.role)
        && variables.equals(another.variables)
        && Objects.equals(defaultStorageLocation, another.defaultStorageLocation)
        && Objects.equals(concurrentConnections, another.concurrentConnections)
        && connectionOptions.equals(another.connectionOptions)
        && defaultEnvironment == another.defaultEnvironment;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code credentialsName}, {@code gcCredentialsName}, {@code azureCredentialsName}, {@code schema}, {@code encrypted}, {@code url}, {@code port}, {@code database}, {@code driver}, {@code user}, {@code role}, {@code variables}, {@code defaultStorageLocation}, {@code concurrentConnections}, {@code connectionOptions}, {@code defaultEnvironment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(credentialsName);
    h += (h << 5) + Objects.hashCode(gcCredentialsName);
    h += (h << 5) + Objects.hashCode(azureCredentialsName);
    h += (h << 5) + Objects.hashCode(schema);
    h += (h << 5) + Objects.hashCode(encrypted);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(database);
    h += (h << 5) + Objects.hashCode(driver);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(role);
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(defaultStorageLocation);
    h += (h << 5) + Objects.hashCode(concurrentConnections);
    h += (h << 5) + connectionOptions.hashCode();
    h += (h << 5) + Boolean.hashCode(defaultEnvironment);
    return h;
  }

  /**
   * Prints the immutable value {@code EnvironmentJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EnvironmentJson{"
        + "name=" + name
        + ", credentialsName=" + credentialsName
        + ", gcCredentialsName=" + gcCredentialsName
        + ", azureCredentialsName=" + azureCredentialsName
        + ", schema=" + schema
        + ", encrypted=" + encrypted
        + ", url=" + url
        + ", port=" + port
        + ", database=" + database
        + ", driver=" + driver
        + ", user=" + user
        + ", role=" + role
        + ", variables=" + variables
        + ", defaultStorageLocation=" + defaultStorageLocation
        + ", concurrentConnections=" + concurrentConnections
        + ", connectionOptions=" + connectionOptions
        + ", defaultEnvironment=" + defaultEnvironment
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "EnvironmentJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements EnvironmentJson {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String credentialsName;
    @javax.annotation.Nullable String gcCredentialsName;
    @javax.annotation.Nullable String azureCredentialsName;
    @javax.annotation.Nullable String schema;
    @javax.annotation.Nullable Boolean encrypted;
    @javax.annotation.Nullable String url;
    @javax.annotation.Nullable String port;
    @javax.annotation.Nullable String database;
    @javax.annotation.Nullable String driver;
    @javax.annotation.Nullable String user;
    @javax.annotation.Nullable String role;
    @javax.annotation.Nullable Map<String, String> variables = Collections.emptyMap();
    boolean variablesIsSet;
    @javax.annotation.Nullable String defaultStorageLocation;
    @javax.annotation.Nullable Integer concurrentConnections;
    @javax.annotation.Nullable Map<String, String> connectionOptions = Collections.emptyMap();
    boolean connectionOptionsIsSet;
    boolean defaultEnvironment;
    boolean defaultEnvironmentIsSet;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("credentialsName")
    public void setCredentialsName(@Nullable String credentialsName) {
      this.credentialsName = credentialsName;
    }
    @JsonProperty("gcCredentialsName")
    public void setGcCredentialsName(@Nullable String gcCredentialsName) {
      this.gcCredentialsName = gcCredentialsName;
    }
    @JsonProperty("azureCredentialsName")
    public void setAzureCredentialsName(@Nullable String azureCredentialsName) {
      this.azureCredentialsName = azureCredentialsName;
    }
    @JsonProperty("schema")
    public void setSchema(@Nullable String schema) {
      this.schema = schema;
    }
    @JsonProperty("encrypted")
    public void setEncrypted(@Nullable Boolean encrypted) {
      this.encrypted = encrypted;
    }
    @JsonProperty("url")
    public void setUrl(@Nullable String url) {
      this.url = url;
    }
    @JsonProperty("port")
    public void setPort(@Nullable String port) {
      this.port = port;
    }
    @JsonProperty("database")
    public void setDatabase(@Nullable String database) {
      this.database = database;
    }
    @JsonProperty("driver")
    public void setDriver(@Nullable String driver) {
      this.driver = driver;
    }
    @JsonProperty("user")
    public void setUser(@Nullable String user) {
      this.user = user;
    }
    @JsonProperty("role")
    public void setRole(@Nullable String role) {
      this.role = role;
    }
    @JsonProperty("variables")
    public void setVariables(Map<String, String> variables) {
      this.variables = variables;
      this.variablesIsSet = null != variables;
    }
    @JsonProperty("defaultStorageLocation")
    public void setDefaultStorageLocation(@Nullable String defaultStorageLocation) {
      this.defaultStorageLocation = defaultStorageLocation;
    }
    @JsonProperty("concurrentConnections")
    public void setConcurrentConnections(@Nullable Integer concurrentConnections) {
      this.concurrentConnections = concurrentConnections;
    }
    @JsonProperty("connectionOptions")
    public void setConnectionOptions(Map<String, String> connectionOptions) {
      this.connectionOptions = connectionOptions;
      this.connectionOptionsIsSet = null != connectionOptions;
    }
    @JsonProperty("defaultEnvironment")
    public void setDefaultEnvironment(boolean defaultEnvironment) {
      this.defaultEnvironment = defaultEnvironment;
      this.defaultEnvironmentIsSet = true;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCredentialsName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGcCredentialsName() { throw new UnsupportedOperationException(); }
    @Override
    public String getAzureCredentialsName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSchema() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEncrypted() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatabase() { throw new UnsupportedOperationException(); }
    @Override
    public String getDriver() { throw new UnsupportedOperationException(); }
    @Override
    public String getUser() { throw new UnsupportedOperationException(); }
    @Override
    public String getRole() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getVariables() { throw new UnsupportedOperationException(); }
    @Override
    public String getDefaultStorageLocation() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getConcurrentConnections() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getConnectionOptions() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDefaultEnvironment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEnvironmentJson fromJson(Json json) {
    ImmutableEnvironmentJson.Builder builder = ImmutableEnvironmentJson.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.credentialsName != null) {
      builder.credentialsName(json.credentialsName);
    }
    if (json.gcCredentialsName != null) {
      builder.gcCredentialsName(json.gcCredentialsName);
    }
    if (json.azureCredentialsName != null) {
      builder.azureCredentialsName(json.azureCredentialsName);
    }
    if (json.schema != null) {
      builder.schema(json.schema);
    }
    if (json.encrypted != null) {
      builder.encrypted(json.encrypted);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.database != null) {
      builder.database(json.database);
    }
    if (json.driver != null) {
      builder.driver(json.driver);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.role != null) {
      builder.role(json.role);
    }
    if (json.variablesIsSet) {
      builder.putAllVariables(json.variables);
    }
    if (json.defaultStorageLocation != null) {
      builder.defaultStorageLocation(json.defaultStorageLocation);
    }
    if (json.concurrentConnections != null) {
      builder.concurrentConnections(json.concurrentConnections);
    }
    if (json.connectionOptionsIsSet) {
      builder.putAllConnectionOptions(json.connectionOptions);
    }
    if (json.defaultEnvironmentIsSet) {
      builder.defaultEnvironment(json.defaultEnvironment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link EnvironmentJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EnvironmentJson instance
   */
  public static ImmutableEnvironmentJson copyOf(EnvironmentJson instance) {
    if (instance instanceof ImmutableEnvironmentJson) {
      return (ImmutableEnvironmentJson) instance;
    }
    return ImmutableEnvironmentJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEnvironmentJson ImmutableEnvironmentJson}.
   * <pre>
   * ImmutableEnvironmentJson.builder()
   *    .name(String | null) // nullable {@link EnvironmentJson#getName() name}
   *    .credentialsName(String | null) // nullable {@link EnvironmentJson#getCredentialsName() credentialsName}
   *    .gcCredentialsName(String | null) // nullable {@link EnvironmentJson#getGcCredentialsName() gcCredentialsName}
   *    .azureCredentialsName(String | null) // nullable {@link EnvironmentJson#getAzureCredentialsName() azureCredentialsName}
   *    .schema(String | null) // nullable {@link EnvironmentJson#getSchema() schema}
   *    .encrypted(Boolean | null) // nullable {@link EnvironmentJson#getEncrypted() encrypted}
   *    .url(String | null) // nullable {@link EnvironmentJson#getUrl() url}
   *    .port(String | null) // nullable {@link EnvironmentJson#getPort() port}
   *    .database(String | null) // nullable {@link EnvironmentJson#getDatabase() database}
   *    .driver(String | null) // nullable {@link EnvironmentJson#getDriver() driver}
   *    .user(String | null) // nullable {@link EnvironmentJson#getUser() user}
   *    .role(String | null) // nullable {@link EnvironmentJson#getRole() role}
   *    .putVariables|putAllVariables(String =&gt; String) // {@link EnvironmentJson#getVariables() variables} mappings
   *    .defaultStorageLocation(String | null) // nullable {@link EnvironmentJson#getDefaultStorageLocation() defaultStorageLocation}
   *    .concurrentConnections(Integer | null) // nullable {@link EnvironmentJson#getConcurrentConnections() concurrentConnections}
   *    .putConnectionOptions|putAllConnectionOptions(String =&gt; String) // {@link EnvironmentJson#getConnectionOptions() connectionOptions} mappings
   *    .defaultEnvironment(boolean) // optional {@link EnvironmentJson#getDefaultEnvironment() defaultEnvironment}
   *    .build();
   * </pre>
   * @return A new ImmutableEnvironmentJson builder
   */
  public static ImmutableEnvironmentJson.Builder builder() {
    return new ImmutableEnvironmentJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEnvironmentJson ImmutableEnvironmentJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnvironmentJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_VARIABLES = 0x1L;
    private static final long OPT_BIT_CONNECTION_OPTIONS = 0x2L;
    private static final long OPT_BIT_DEFAULT_ENVIRONMENT = 0x4L;
    private long optBits;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String credentialsName;
    private @javax.annotation.Nullable String gcCredentialsName;
    private @javax.annotation.Nullable String azureCredentialsName;
    private @javax.annotation.Nullable String schema;
    private @javax.annotation.Nullable Boolean encrypted;
    private @javax.annotation.Nullable String url;
    private @javax.annotation.Nullable String port;
    private @javax.annotation.Nullable String database;
    private @javax.annotation.Nullable String driver;
    private @javax.annotation.Nullable String user;
    private @javax.annotation.Nullable String role;
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    private @javax.annotation.Nullable String defaultStorageLocation;
    private @javax.annotation.Nullable Integer concurrentConnections;
    private Map<String, String> connectionOptions = new LinkedHashMap<String, String>();
    private boolean defaultEnvironment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EnvironmentJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EnvironmentJson instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String credentialsNameValue = instance.getCredentialsName();
      if (credentialsNameValue != null) {
        credentialsName(credentialsNameValue);
      }
      @Nullable String gcCredentialsNameValue = instance.getGcCredentialsName();
      if (gcCredentialsNameValue != null) {
        gcCredentialsName(gcCredentialsNameValue);
      }
      @Nullable String azureCredentialsNameValue = instance.getAzureCredentialsName();
      if (azureCredentialsNameValue != null) {
        azureCredentialsName(azureCredentialsNameValue);
      }
      @Nullable String schemaValue = instance.getSchema();
      if (schemaValue != null) {
        schema(schemaValue);
      }
      @Nullable Boolean encryptedValue = instance.getEncrypted();
      if (encryptedValue != null) {
        encrypted(encryptedValue);
      }
      @Nullable String urlValue = instance.getUrl();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable String portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      @Nullable String databaseValue = instance.getDatabase();
      if (databaseValue != null) {
        database(databaseValue);
      }
      @Nullable String driverValue = instance.getDriver();
      if (driverValue != null) {
        driver(driverValue);
      }
      @Nullable String userValue = instance.getUser();
      if (userValue != null) {
        user(userValue);
      }
      @Nullable String roleValue = instance.getRole();
      if (roleValue != null) {
        role(roleValue);
      }
      putAllVariables(instance.getVariables());
      @Nullable String defaultStorageLocationValue = instance.getDefaultStorageLocation();
      if (defaultStorageLocationValue != null) {
        defaultStorageLocation(defaultStorageLocationValue);
      }
      @Nullable Integer concurrentConnectionsValue = instance.getConcurrentConnections();
      if (concurrentConnectionsValue != null) {
        concurrentConnections(concurrentConnectionsValue);
      }
      putAllConnectionOptions(instance.getConnectionOptions());
      this.defaultEnvironment(instance.getDefaultEnvironment());
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getCredentialsName() credentialsName} attribute.
     * @param credentialsName The value for credentialsName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentialsName")
    public final Builder credentialsName(@Nullable String credentialsName) {
      this.credentialsName = credentialsName;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getGcCredentialsName() gcCredentialsName} attribute.
     * @param gcCredentialsName The value for gcCredentialsName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("gcCredentialsName")
    public final Builder gcCredentialsName(@Nullable String gcCredentialsName) {
      this.gcCredentialsName = gcCredentialsName;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getAzureCredentialsName() azureCredentialsName} attribute.
     * @param azureCredentialsName The value for azureCredentialsName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("azureCredentialsName")
    public final Builder azureCredentialsName(@Nullable String azureCredentialsName) {
      this.azureCredentialsName = azureCredentialsName;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getSchema() schema} attribute.
     * @param schema The value for schema (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schema")
    public final Builder schema(@Nullable String schema) {
      this.schema = schema;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getEncrypted() encrypted} attribute.
     * @param encrypted The value for encrypted (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("encrypted")
    public final Builder encrypted(@Nullable Boolean encrypted) {
      this.encrypted = encrypted;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getUrl() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("url")
    public final Builder url(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(@Nullable String port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getDatabase() database} attribute.
     * @param database The value for database (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("database")
    public final Builder database(@Nullable String database) {
      this.database = database;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getDriver() driver} attribute.
     * @param driver The value for driver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("driver")
    public final Builder driver(@Nullable String driver) {
      this.driver = driver;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getUser() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user")
    public final Builder user(@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getRole() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("role")
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Put one entry to the {@link EnvironmentJson#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.variables.put(key, value);
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Put one entry to the {@link EnvironmentJson#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.variables.put(k, v);
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EnvironmentJson#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("variables")
    public final Builder variables(Map<String, ? extends String> entries) {
      this.variables.clear();
      optBits |= OPT_BIT_VARIABLES;
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EnvironmentJson#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.variables.put(k, v);
      }
      optBits |= OPT_BIT_VARIABLES;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getDefaultStorageLocation() defaultStorageLocation} attribute.
     * @param defaultStorageLocation The value for defaultStorageLocation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultStorageLocation")
    public final Builder defaultStorageLocation(@Nullable String defaultStorageLocation) {
      this.defaultStorageLocation = defaultStorageLocation;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getConcurrentConnections() concurrentConnections} attribute.
     * @param concurrentConnections The value for concurrentConnections (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("concurrentConnections")
    public final Builder concurrentConnections(@Nullable Integer concurrentConnections) {
      this.concurrentConnections = concurrentConnections;
      return this;
    }

    /**
     * Put one entry to the {@link EnvironmentJson#getConnectionOptions() connectionOptions} map.
     * @param key The key in the connectionOptions map
     * @param value The associated value in the connectionOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConnectionOptions(String key, String value) {
      this.connectionOptions.put(
          Objects.requireNonNull(key, "connectionOptions key"),
          Objects.requireNonNull(value, value == null ? "connectionOptions value for key: " + key : null));
      optBits |= OPT_BIT_CONNECTION_OPTIONS;
      return this;
    }

    /**
     * Put one entry to the {@link EnvironmentJson#getConnectionOptions() connectionOptions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConnectionOptions(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.connectionOptions.put(
          Objects.requireNonNull(k, "connectionOptions key"),
          Objects.requireNonNull(v, v == null ? "connectionOptions value for key: " + k : null));
      optBits |= OPT_BIT_CONNECTION_OPTIONS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EnvironmentJson#getConnectionOptions() connectionOptions} map. Nulls are not permitted
     * @param entries The entries that will be added to the connectionOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connectionOptions")
    public final Builder connectionOptions(Map<String, ? extends String> entries) {
      this.connectionOptions.clear();
      optBits |= OPT_BIT_CONNECTION_OPTIONS;
      return putAllConnectionOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EnvironmentJson#getConnectionOptions() connectionOptions} map. Nulls are not permitted
     * @param entries The entries that will be added to the connectionOptions map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllConnectionOptions(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.connectionOptions.put(
            Objects.requireNonNull(k, "connectionOptions key"),
            Objects.requireNonNull(v, v == null ? "connectionOptions value for key: " + k : null));
      }
      optBits |= OPT_BIT_CONNECTION_OPTIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link EnvironmentJson#getDefaultEnvironment() defaultEnvironment} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link EnvironmentJson#getDefaultEnvironment() defaultEnvironment}.</em>
     * @param defaultEnvironment The value for defaultEnvironment 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultEnvironment")
    public final Builder defaultEnvironment(boolean defaultEnvironment) {
      this.defaultEnvironment = defaultEnvironment;
      optBits |= OPT_BIT_DEFAULT_ENVIRONMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEnvironmentJson ImmutableEnvironmentJson}.
     * @return An immutable instance of EnvironmentJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnvironmentJson build() {
      return new ImmutableEnvironmentJson(this);
    }

    private boolean variablesIsSet() {
      return (optBits & OPT_BIT_VARIABLES) != 0;
    }

    private boolean connectionOptionsIsSet() {
      return (optBits & OPT_BIT_CONNECTION_OPTIONS) != 0;
    }

    private boolean defaultEnvironmentIsSet() {
      return (optBits & OPT_BIT_DEFAULT_ENVIRONMENT) != 0;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
