package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ElementValueJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableElementValueJson.builder()}.
 */
@Generated(from = "ElementValueJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableElementValueJson implements ElementValueJson {
  private final int slot;
  private final String type;
  private final @Nullable String value;

  private ImmutableElementValueJson(int slot, String type, @Nullable String value) {
    this.slot = slot;
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code slot} attribute
   */
  @JsonProperty("slot")
  @Override
  public int slot() {
    return slot;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public @Nullable String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElementValueJson#slot() slot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slot
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElementValueJson withSlot(int value) {
    if (this.slot == value) return this;
    return new ImmutableElementValueJson(value, this.type, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElementValueJson#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElementValueJson withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableElementValueJson(this.slot, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElementValueJson#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElementValueJson withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableElementValueJson(this.slot, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableElementValueJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableElementValueJson
        && equalTo(0, (ImmutableElementValueJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableElementValueJson another) {
    return slot == another.slot
        && type.equals(another.type)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code slot}, {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + slot;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code ElementValueJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ElementValueJson{"
        + "slot=" + slot
        + ", type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ElementValueJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ElementValueJson {
    int slot;
    boolean slotIsSet;
    @Nullable String type;
    @Nullable String value;
    @JsonProperty("slot")
    public void setSlot(int slot) {
      this.slot = slot;
      this.slotIsSet = true;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("value")
    public void setValue(@Nullable String value) {
      this.value = value;
    }
    @Override
    public int slot() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public String value() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableElementValueJson fromJson(Json json) {
    ImmutableElementValueJson.Builder builder = ImmutableElementValueJson.builder();
    if (json.slotIsSet) {
      builder.slot(json.slot);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ElementValueJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ElementValueJson instance
   */
  public static ImmutableElementValueJson copyOf(ElementValueJson instance) {
    if (instance instanceof ImmutableElementValueJson) {
      return (ImmutableElementValueJson) instance;
    }
    return ImmutableElementValueJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableElementValueJson ImmutableElementValueJson}.
   * <pre>
   * ImmutableElementValueJson.builder()
   *    .slot(int) // required {@link ElementValueJson#slot() slot}
   *    .type(String) // required {@link ElementValueJson#type() type}
   *    .value(String | null) // nullable {@link ElementValueJson#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableElementValueJson builder
   */
  public static ImmutableElementValueJson.Builder builder() {
    return new ImmutableElementValueJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableElementValueJson ImmutableElementValueJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ElementValueJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SLOT = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private int slot;
    private @Nullable String type;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ElementValueJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ElementValueJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.slot(instance.slot());
      this.type(instance.type());
      @Nullable String valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ElementValueJson#slot() slot} attribute.
     * @param slot The value for slot 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("slot")
    public final Builder slot(int slot) {
      this.slot = slot;
      initBits &= ~INIT_BIT_SLOT;
      return this;
    }

    /**
     * Initializes the value for the {@link ElementValueJson#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ElementValueJson#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableElementValueJson ImmutableElementValueJson}.
     * @return An immutable instance of ElementValueJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableElementValueJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableElementValueJson(slot, type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SLOT) != 0) attributes.add("slot");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ElementValueJson, some of required attributes are not set " + attributes;
    }
  }
}
