package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ElementJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableElementJson.builder()}.
 */
@Generated(from = "ElementJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableElementJson implements ElementJson {
  private final int slot;
  private final Map<String, ElementValueJson> values;

  private ImmutableElementJson(ImmutableElementJson.Builder builder) {
    this.slot = builder.slot;
    this.values = builder.valuesIsSet()
        ? createUnmodifiableMap(false, false, builder.values)
        : createUnmodifiableMap(true, false, ElementJson.super.values());
  }

  private ImmutableElementJson(
      int slot,
      Map<String, ElementValueJson> values) {
    this.slot = slot;
    this.values = values;
  }

  /**
   * @return The value of the {@code slot} attribute
   */
  @JsonProperty("slot")
  @Override
  public int slot() {
    return slot;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @JsonProperty("values")
  @Override
  public Map<String, ElementValueJson> values() {
    return values;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ElementJson#slot() slot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slot
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableElementJson withSlot(int value) {
    if (this.slot == value) return this;
    return new ImmutableElementJson(value, this.values);
  }

  /**
   * Copy the current immutable object by replacing the {@link ElementJson#values() values} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the values map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableElementJson withValues(Map<String, ? extends ElementValueJson> entries) {
    if (this.values == entries) return this;
    Map<String, ElementValueJson> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableElementJson(this.slot, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableElementJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableElementJson
        && equalTo(0, (ImmutableElementJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableElementJson another) {
    return slot == another.slot
        && values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code slot}, {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + slot;
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ElementJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ElementJson{"
        + "slot=" + slot
        + ", values=" + values
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ElementJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ElementJson {
    int slot;
    boolean slotIsSet;
    @Nullable Map<String, ElementValueJson> values = Collections.emptyMap();
    boolean valuesIsSet;
    @JsonProperty("slot")
    public void setSlot(int slot) {
      this.slot = slot;
      this.slotIsSet = true;
    }
    @JsonProperty("values")
    public void setValues(Map<String, ElementValueJson> values) {
      this.values = values;
      this.valuesIsSet = null != values;
    }
    @Override
    public int slot() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ElementValueJson> values() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableElementJson fromJson(Json json) {
    ImmutableElementJson.Builder builder = ImmutableElementJson.builder();
    if (json.slotIsSet) {
      builder.slot(json.slot);
    }
    if (json.valuesIsSet) {
      builder.putAllValues(json.values);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ElementJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ElementJson instance
   */
  public static ImmutableElementJson copyOf(ElementJson instance) {
    if (instance instanceof ImmutableElementJson) {
      return (ImmutableElementJson) instance;
    }
    return ImmutableElementJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableElementJson ImmutableElementJson}.
   * <pre>
   * ImmutableElementJson.builder()
   *    .slot(int) // required {@link ElementJson#slot() slot}
   *    .putValues|putAllValues(String =&gt; zeenea.connector.matillion.etl.client.ElementValueJson) // {@link ElementJson#values() values} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableElementJson builder
   */
  public static ImmutableElementJson.Builder builder() {
    return new ImmutableElementJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableElementJson ImmutableElementJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ElementJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SLOT = 0x1L;
    private static final long OPT_BIT_VALUES = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private int slot;
    private Map<String, ElementValueJson> values = new LinkedHashMap<String, ElementValueJson>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ElementJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ElementJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.slot(instance.slot());
      putAllValues(instance.values());
      return this;
    }

    /**
     * Initializes the value for the {@link ElementJson#slot() slot} attribute.
     * @param slot The value for slot 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("slot")
    public final Builder slot(int slot) {
      this.slot = slot;
      initBits &= ~INIT_BIT_SLOT;
      return this;
    }

    /**
     * Put one entry to the {@link ElementJson#values() values} map.
     * @param key The key in the values map
     * @param value The associated value in the values map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putValues(String key, ElementValueJson value) {
      this.values.put(
          Objects.requireNonNull(key, "values key"),
          Objects.requireNonNull(value, value == null ? "values value for key: " + key : null));
      optBits |= OPT_BIT_VALUES;
      return this;
    }

    /**
     * Put one entry to the {@link ElementJson#values() values} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putValues(Map.Entry<String, ? extends ElementValueJson> entry) {
      String k = entry.getKey();
      ElementValueJson v = entry.getValue();
      this.values.put(
          Objects.requireNonNull(k, "values key"),
          Objects.requireNonNull(v, v == null ? "values value for key: " + k : null));
      optBits |= OPT_BIT_VALUES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ElementJson#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("values")
    public final Builder values(Map<String, ? extends ElementValueJson> entries) {
      this.values.clear();
      optBits |= OPT_BIT_VALUES;
      return putAllValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ElementJson#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllValues(Map<String, ? extends ElementValueJson> entries) {
      for (Map.Entry<String, ? extends ElementValueJson> e : entries.entrySet()) {
        String k = e.getKey();
        ElementValueJson v = e.getValue();
        this.values.put(
            Objects.requireNonNull(k, "values key"),
            Objects.requireNonNull(v, v == null ? "values value for key: " + k : null));
      }
      optBits |= OPT_BIT_VALUES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableElementJson ImmutableElementJson}.
     * @return An immutable instance of ElementJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableElementJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableElementJson(this);
    }

    private boolean valuesIsSet() {
      return (optBits & OPT_BIT_VALUES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SLOT) != 0) attributes.add("slot");
      return "Cannot build ElementJson, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
