package zeenea.connector.matillion.etl.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ComponentJson}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComponentJson.builder()}.
 */
@Generated(from = "ComponentJson", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableComponentJson implements ComponentJson {
  private final long id;
  private final Cardinality inputCardinality;
  private final Cardinality outputCardinality;
  private final Map<String, ParameterJson> parameters;

  private ImmutableComponentJson(ImmutableComponentJson.Builder builder) {
    this.id = builder.id;
    this.inputCardinality = builder.inputCardinality;
    this.outputCardinality = builder.outputCardinality;
    this.parameters = builder.parametersIsSet()
        ? createUnmodifiableMap(false, false, builder.parameters)
        : createUnmodifiableMap(true, false, ComponentJson.super.parameters());
  }

  private ImmutableComponentJson(
      long id,
      Cardinality inputCardinality,
      Cardinality outputCardinality,
      Map<String, ParameterJson> parameters) {
    this.id = id;
    this.inputCardinality = inputCardinality;
    this.outputCardinality = outputCardinality;
    this.parameters = parameters;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public long id() {
    return id;
  }

  /**
   * @return The value of the {@code inputCardinality} attribute
   */
  @JsonProperty("inputCardinality")
  @Override
  public Cardinality inputCardinality() {
    return inputCardinality;
  }

  /**
   * @return The value of the {@code outputCardinality} attribute
   */
  @JsonProperty("outputCardinality")
  @Override
  public Cardinality outputCardinality() {
    return outputCardinality;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @JsonProperty("parameters")
  @Override
  public Map<String, ParameterJson> parameters() {
    return parameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComponentJson#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponentJson withId(long value) {
    if (this.id == value) return this;
    return new ImmutableComponentJson(value, this.inputCardinality, this.outputCardinality, this.parameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComponentJson#inputCardinality() inputCardinality} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputCardinality
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponentJson withInputCardinality(Cardinality value) {
    Cardinality newValue = Objects.requireNonNull(value, "inputCardinality");
    if (this.inputCardinality == newValue) return this;
    return new ImmutableComponentJson(this.id, newValue, this.outputCardinality, this.parameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ComponentJson#outputCardinality() outputCardinality} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputCardinality
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponentJson withOutputCardinality(Cardinality value) {
    Cardinality newValue = Objects.requireNonNull(value, "outputCardinality");
    if (this.outputCardinality == newValue) return this;
    return new ImmutableComponentJson(this.id, this.inputCardinality, newValue, this.parameters);
  }

  /**
   * Copy the current immutable object by replacing the {@link ComponentJson#parameters() parameters} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the parameters map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComponentJson withParameters(Map<String, ? extends ParameterJson> entries) {
    if (this.parameters == entries) return this;
    Map<String, ParameterJson> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableComponentJson(this.id, this.inputCardinality, this.outputCardinality, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComponentJson} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComponentJson
        && equalTo(0, (ImmutableComponentJson) another);
  }

  private boolean equalTo(int synthetic, ImmutableComponentJson another) {
    return id == another.id
        && inputCardinality.equals(another.inputCardinality)
        && outputCardinality.equals(another.outputCardinality)
        && parameters.equals(another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code inputCardinality}, {@code outputCardinality}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(id);
    h += (h << 5) + inputCardinality.hashCode();
    h += (h << 5) + outputCardinality.hashCode();
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ComponentJson} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ComponentJson{"
        + "id=" + id
        + ", inputCardinality=" + inputCardinality
        + ", outputCardinality=" + outputCardinality
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ComponentJson", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ComponentJson {
    long id;
    boolean idIsSet;
    @Nullable Cardinality inputCardinality;
    @Nullable Cardinality outputCardinality;
    @Nullable Map<String, ParameterJson> parameters = Collections.emptyMap();
    boolean parametersIsSet;
    @JsonProperty("id")
    public void setId(long id) {
      this.id = id;
      this.idIsSet = true;
    }
    @JsonProperty("inputCardinality")
    public void setInputCardinality(Cardinality inputCardinality) {
      this.inputCardinality = inputCardinality;
    }
    @JsonProperty("outputCardinality")
    public void setOutputCardinality(Cardinality outputCardinality) {
      this.outputCardinality = outputCardinality;
    }
    @JsonProperty("parameters")
    public void setParameters(Map<String, ParameterJson> parameters) {
      this.parameters = parameters;
      this.parametersIsSet = null != parameters;
    }
    @Override
    public long id() { throw new UnsupportedOperationException(); }
    @Override
    public Cardinality inputCardinality() { throw new UnsupportedOperationException(); }
    @Override
    public Cardinality outputCardinality() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, ParameterJson> parameters() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableComponentJson fromJson(Json json) {
    ImmutableComponentJson.Builder builder = ImmutableComponentJson.builder();
    if (json.idIsSet) {
      builder.id(json.id);
    }
    if (json.inputCardinality != null) {
      builder.inputCardinality(json.inputCardinality);
    }
    if (json.outputCardinality != null) {
      builder.outputCardinality(json.outputCardinality);
    }
    if (json.parametersIsSet) {
      builder.putAllParameters(json.parameters);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ComponentJson} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ComponentJson instance
   */
  public static ImmutableComponentJson copyOf(ComponentJson instance) {
    if (instance instanceof ImmutableComponentJson) {
      return (ImmutableComponentJson) instance;
    }
    return ImmutableComponentJson.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComponentJson ImmutableComponentJson}.
   * <pre>
   * ImmutableComponentJson.builder()
   *    .id(long) // required {@link ComponentJson#id() id}
   *    .inputCardinality(zeenea.connector.matillion.etl.client.Cardinality) // required {@link ComponentJson#inputCardinality() inputCardinality}
   *    .outputCardinality(zeenea.connector.matillion.etl.client.Cardinality) // required {@link ComponentJson#outputCardinality() outputCardinality}
   *    .putParameters|putAllParameters(String =&gt; zeenea.connector.matillion.etl.client.ParameterJson) // {@link ComponentJson#parameters() parameters} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableComponentJson builder
   */
  public static ImmutableComponentJson.Builder builder() {
    return new ImmutableComponentJson.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComponentJson ImmutableComponentJson}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ComponentJson", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_INPUT_CARDINALITY = 0x2L;
    private static final long INIT_BIT_OUTPUT_CARDINALITY = 0x4L;
    private static final long OPT_BIT_PARAMETERS = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private long id;
    private @Nullable Cardinality inputCardinality;
    private @Nullable Cardinality outputCardinality;
    private Map<String, ParameterJson> parameters = new LinkedHashMap<String, ParameterJson>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ComponentJson} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ComponentJson instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      this.inputCardinality(instance.inputCardinality());
      this.outputCardinality(instance.outputCardinality());
      putAllParameters(instance.parameters());
      return this;
    }

    /**
     * Initializes the value for the {@link ComponentJson#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(long id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ComponentJson#inputCardinality() inputCardinality} attribute.
     * @param inputCardinality The value for inputCardinality 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("inputCardinality")
    public final Builder inputCardinality(Cardinality inputCardinality) {
      this.inputCardinality = Objects.requireNonNull(inputCardinality, "inputCardinality");
      initBits &= ~INIT_BIT_INPUT_CARDINALITY;
      return this;
    }

    /**
     * Initializes the value for the {@link ComponentJson#outputCardinality() outputCardinality} attribute.
     * @param outputCardinality The value for outputCardinality 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("outputCardinality")
    public final Builder outputCardinality(Cardinality outputCardinality) {
      this.outputCardinality = Objects.requireNonNull(outputCardinality, "outputCardinality");
      initBits &= ~INIT_BIT_OUTPUT_CARDINALITY;
      return this;
    }

    /**
     * Put one entry to the {@link ComponentJson#parameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParameters(String key, ParameterJson value) {
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, value == null ? "parameters value for key: " + key : null));
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Put one entry to the {@link ComponentJson#parameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParameters(Map.Entry<String, ? extends ParameterJson> entry) {
      String k = entry.getKey();
      ParameterJson v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ComponentJson#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parameters")
    public final Builder parameters(Map<String, ? extends ParameterJson> entries) {
      this.parameters.clear();
      optBits |= OPT_BIT_PARAMETERS;
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ComponentJson#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends ParameterJson> entries) {
      for (Map.Entry<String, ? extends ParameterJson> e : entries.entrySet()) {
        String k = e.getKey();
        ParameterJson v = e.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      }
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComponentJson ImmutableComponentJson}.
     * @return An immutable instance of ComponentJson
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComponentJson build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComponentJson(this);
    }

    private boolean parametersIsSet() {
      return (optBits & OPT_BIT_PARAMETERS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INPUT_CARDINALITY) != 0) attributes.add("inputCardinality");
      if ((initBits & INIT_BIT_OUTPUT_CARDINALITY) != 0) attributes.add("outputCardinality");
      return "Cannot build ComponentJson, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
