package zeenea.connector.matillion.etl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link VersionCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVersionCtx.builder()}.
 */
@Generated(from = "VersionCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVersionCtx implements VersionCtx {
  @NotNull
  private final ProjectCtx projectCtx;
  @NotNull
  private final String versionName;

  private ImmutableVersionCtx(ProjectCtx projectCtx, String versionName) {
    this.projectCtx = projectCtx;
    this.versionName = versionName;
  }

  /**
   * @return The value of the {@code projectCtx} attribute
   */
  @JsonProperty("projectCtx")
  @NotNull
  @Override
  public ProjectCtx projectCtx() {
    return projectCtx;
  }

  /**
   * @return The value of the {@code versionName} attribute
   */
  @JsonProperty("versionName")
  @NotNull
  @Override
  public String versionName() {
    return versionName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VersionCtx#projectCtx() projectCtx} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectCtx
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVersionCtx withProjectCtx(ProjectCtx value) {
    if (this.projectCtx == value) return this;
    ProjectCtx newValue = Objects.requireNonNull(value, "projectCtx");
    return new ImmutableVersionCtx(newValue, this.versionName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VersionCtx#versionName() versionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for versionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVersionCtx withVersionName(String value) {
    String newValue = Objects.requireNonNull(value, "versionName");
    if (this.versionName.equals(newValue)) return this;
    return new ImmutableVersionCtx(this.projectCtx, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVersionCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVersionCtx
        && equalTo(0, (ImmutableVersionCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableVersionCtx another) {
    return projectCtx.equals(another.projectCtx)
        && versionName.equals(another.versionName);
  }

  /**
   * Computes a hash code from attributes: {@code projectCtx}, {@code versionName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + projectCtx.hashCode();
    h += (h << 5) + versionName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VersionCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VersionCtx{"
        + "projectCtx=" + projectCtx
        + ", versionName=" + versionName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "VersionCtx", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements VersionCtx {
    @Nullable ProjectCtx projectCtx;
    @Nullable String versionName;
    @JsonProperty("projectCtx")
    public void setProjectCtx(ProjectCtx projectCtx) {
      this.projectCtx = projectCtx;
    }
    @JsonProperty("versionName")
    public void setVersionName(String versionName) {
      this.versionName = versionName;
    }
    @Override
    public ProjectCtx projectCtx() { throw new UnsupportedOperationException(); }
    @Override
    public String versionName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVersionCtx fromJson(Json json) {
    ImmutableVersionCtx.Builder builder = ImmutableVersionCtx.builder();
    if (json.projectCtx != null) {
      builder.projectCtx(json.projectCtx);
    }
    if (json.versionName != null) {
      builder.versionName(json.versionName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link VersionCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VersionCtx instance
   */
  public static ImmutableVersionCtx copyOf(VersionCtx instance) {
    if (instance instanceof ImmutableVersionCtx) {
      return (ImmutableVersionCtx) instance;
    }
    return ImmutableVersionCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVersionCtx ImmutableVersionCtx}.
   * <pre>
   * ImmutableVersionCtx.builder()
   *    .projectCtx(zeenea.connector.matillion.etl.ProjectCtx) // required {@link VersionCtx#projectCtx() projectCtx}
   *    .versionName(String) // required {@link VersionCtx#versionName() versionName}
   *    .build();
   * </pre>
   * @return A new ImmutableVersionCtx builder
   */
  public static ImmutableVersionCtx.Builder builder() {
    return new ImmutableVersionCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVersionCtx ImmutableVersionCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VersionCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT_CTX = 0x1L;
    private static final long INIT_BIT_VERSION_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ProjectCtx projectCtx;
    private @Nullable String versionName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VersionCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VersionCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.projectCtx(instance.projectCtx());
      this.versionName(instance.versionName());
      return this;
    }

    /**
     * Initializes the value for the {@link VersionCtx#projectCtx() projectCtx} attribute.
     * @param projectCtx The value for projectCtx 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projectCtx")
    public final Builder projectCtx(ProjectCtx projectCtx) {
      this.projectCtx = Objects.requireNonNull(projectCtx, "projectCtx");
      initBits &= ~INIT_BIT_PROJECT_CTX;
      return this;
    }

    /**
     * Initializes the value for the {@link VersionCtx#versionName() versionName} attribute.
     * @param versionName The value for versionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("versionName")
    public final Builder versionName(String versionName) {
      this.versionName = Objects.requireNonNull(versionName, "versionName");
      initBits &= ~INIT_BIT_VERSION_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVersionCtx ImmutableVersionCtx}.
     * @return An immutable instance of VersionCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVersionCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVersionCtx(projectCtx, versionName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT_CTX) != 0) attributes.add("projectCtx");
      if ((initBits & INIT_BIT_VERSION_NAME) != 0) attributes.add("versionName");
      return "Cannot build VersionCtx, some of required attributes are not set " + attributes;
    }
  }
}
