package zeenea.connector.matillion.etl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.util.Lazy;
import zeenea.connector.matillion.etl.client.EnvironmentJson;

/**
 * Immutable implementation of {@link ProjectCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectCtx.builder()}.
 */
@Generated(from = "ProjectCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProjectCtx implements ProjectCtx {
  @NotNull
  private final GroupCtx groupCtx;
  @NotNull
  private final String projectName;
  @NotNull
  private final Lazy<EnvironmentJson> defaultEnvironment;

  private ImmutableProjectCtx(
      GroupCtx groupCtx,
      String projectName,
      Lazy<EnvironmentJson> defaultEnvironment) {
    this.groupCtx = groupCtx;
    this.projectName = projectName;
    this.defaultEnvironment = defaultEnvironment;
  }

  /**
   * @return The value of the {@code groupCtx} attribute
   */
  @JsonProperty("groupCtx")
  @NotNull
  @Override
  public GroupCtx groupCtx() {
    return groupCtx;
  }

  /**
   * @return The value of the {@code projectName} attribute
   */
  @JsonProperty("projectName")
  @NotNull
  @Override
  public String projectName() {
    return projectName;
  }

  /**
   * @return The value of the {@code defaultEnvironment} attribute
   */
  @JsonProperty("defaultEnvironment")
  @NotNull
  @Override
  public Lazy<EnvironmentJson> defaultEnvironment() {
    return defaultEnvironment;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectCtx#groupCtx() groupCtx} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupCtx
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectCtx withGroupCtx(GroupCtx value) {
    if (this.groupCtx == value) return this;
    GroupCtx newValue = Objects.requireNonNull(value, "groupCtx");
    return new ImmutableProjectCtx(newValue, this.projectName, this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectCtx#projectName() projectName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectCtx withProjectName(String value) {
    String newValue = Objects.requireNonNull(value, "projectName");
    if (this.projectName.equals(newValue)) return this;
    return new ImmutableProjectCtx(this.groupCtx, newValue, this.defaultEnvironment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProjectCtx#defaultEnvironment() defaultEnvironment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultEnvironment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectCtx withDefaultEnvironment(Lazy<EnvironmentJson> value) {
    if (this.defaultEnvironment == value) return this;
    Lazy<EnvironmentJson> newValue = Objects.requireNonNull(value, "defaultEnvironment");
    return new ImmutableProjectCtx(this.groupCtx, this.projectName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectCtx
        && equalTo(0, (ImmutableProjectCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableProjectCtx another) {
    return groupCtx.equals(another.groupCtx)
        && projectName.equals(another.projectName);
  }

  /**
   * Computes a hash code from attributes: {@code groupCtx}, {@code projectName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupCtx.hashCode();
    h += (h << 5) + projectName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProjectCtx{"
        + "groupCtx=" + groupCtx
        + ", projectName=" + projectName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ProjectCtx", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ProjectCtx {
    @Nullable GroupCtx groupCtx;
    @Nullable String projectName;
    @Nullable Lazy<EnvironmentJson> defaultEnvironment;
    @JsonProperty("groupCtx")
    public void setGroupCtx(GroupCtx groupCtx) {
      this.groupCtx = groupCtx;
    }
    @JsonProperty("projectName")
    public void setProjectName(String projectName) {
      this.projectName = projectName;
    }
    @JsonProperty("defaultEnvironment")
    public void setDefaultEnvironment(Lazy<EnvironmentJson> defaultEnvironment) {
      this.defaultEnvironment = defaultEnvironment;
    }
    @Override
    public GroupCtx groupCtx() { throw new UnsupportedOperationException(); }
    @Override
    public String projectName() { throw new UnsupportedOperationException(); }
    @Override
    public Lazy<EnvironmentJson> defaultEnvironment() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProjectCtx fromJson(Json json) {
    ImmutableProjectCtx.Builder builder = ImmutableProjectCtx.builder();
    if (json.groupCtx != null) {
      builder.groupCtx(json.groupCtx);
    }
    if (json.projectName != null) {
      builder.projectName(json.projectName);
    }
    if (json.defaultEnvironment != null) {
      builder.defaultEnvironment(json.defaultEnvironment);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ProjectCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectCtx instance
   */
  public static ImmutableProjectCtx copyOf(ProjectCtx instance) {
    if (instance instanceof ImmutableProjectCtx) {
      return (ImmutableProjectCtx) instance;
    }
    return ImmutableProjectCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectCtx ImmutableProjectCtx}.
   * <pre>
   * ImmutableProjectCtx.builder()
   *    .groupCtx(zeenea.connector.matillion.etl.GroupCtx) // required {@link ProjectCtx#groupCtx() groupCtx}
   *    .projectName(String) // required {@link ProjectCtx#projectName() projectName}
   *    .defaultEnvironment(zeenea.connector.commons.util.Lazy&amp;lt;zeenea.connector.matillion.etl.client.EnvironmentJson&amp;gt;) // required {@link ProjectCtx#defaultEnvironment() defaultEnvironment}
   *    .build();
   * </pre>
   * @return A new ImmutableProjectCtx builder
   */
  public static ImmutableProjectCtx.Builder builder() {
    return new ImmutableProjectCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectCtx ImmutableProjectCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProjectCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GROUP_CTX = 0x1L;
    private static final long INIT_BIT_PROJECT_NAME = 0x2L;
    private static final long INIT_BIT_DEFAULT_ENVIRONMENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable GroupCtx groupCtx;
    private @Nullable String projectName;
    private @Nullable Lazy<EnvironmentJson> defaultEnvironment;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProjectCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.groupCtx(instance.groupCtx());
      this.projectName(instance.projectName());
      this.defaultEnvironment(instance.defaultEnvironment());
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectCtx#groupCtx() groupCtx} attribute.
     * @param groupCtx The value for groupCtx 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupCtx")
    public final Builder groupCtx(GroupCtx groupCtx) {
      this.groupCtx = Objects.requireNonNull(groupCtx, "groupCtx");
      initBits &= ~INIT_BIT_GROUP_CTX;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectCtx#projectName() projectName} attribute.
     * @param projectName The value for projectName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projectName")
    public final Builder projectName(String projectName) {
      this.projectName = Objects.requireNonNull(projectName, "projectName");
      initBits &= ~INIT_BIT_PROJECT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ProjectCtx#defaultEnvironment() defaultEnvironment} attribute.
     * @param defaultEnvironment The value for defaultEnvironment 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultEnvironment")
    public final Builder defaultEnvironment(Lazy<EnvironmentJson> defaultEnvironment) {
      this.defaultEnvironment = Objects.requireNonNull(defaultEnvironment, "defaultEnvironment");
      initBits &= ~INIT_BIT_DEFAULT_ENVIRONMENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectCtx ImmutableProjectCtx}.
     * @return An immutable instance of ProjectCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectCtx(groupCtx, projectName, defaultEnvironment);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_CTX) != 0) attributes.add("groupCtx");
      if ((initBits & INIT_BIT_PROJECT_NAME) != 0) attributes.add("projectName");
      if ((initBits & INIT_BIT_DEFAULT_ENVIRONMENT) != 0) attributes.add("defaultEnvironment");
      return "Cannot build ProjectCtx, some of required attributes are not set " + attributes;
    }
  }
}
