package zeenea.connector.matillion.etl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParameterValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParameterValue.builder()}.
 */
@Generated(from = "ParameterValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableParameterValue implements ParameterValue {
  private final String type;
  private final @Nullable String value;

  private ImmutableParameterValue(String type, @Nullable String value) {
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParameterValue#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameterValue withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableParameterValue(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParameterValue#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameterValue withValue(@Nullable String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableParameterValue(this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameterValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameterValue
        && equalTo(0, (ImmutableParameterValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableParameterValue another) {
    return type.equals(another.type)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code ParameterValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ParameterValue{"
        + "type=" + type
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ParameterValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParameterValue instance
   */
  public static ImmutableParameterValue copyOf(ParameterValue instance) {
    if (instance instanceof ImmutableParameterValue) {
      return (ImmutableParameterValue) instance;
    }
    return ImmutableParameterValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParameterValue ImmutableParameterValue}.
   * <pre>
   * ImmutableParameterValue.builder()
   *    .type(String) // required {@link ParameterValue#type() type}
   *    .value(String | null) // nullable {@link ParameterValue#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableParameterValue builder
   */
  public static ImmutableParameterValue.Builder builder() {
    return new ImmutableParameterValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParameterValue ImmutableParameterValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParameterValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String type;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParameterValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ParameterValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      @Nullable String valueValue = instance.value();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ParameterValue#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link ParameterValue#value() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableParameterValue ImmutableParameterValue}.
     * @return An immutable instance of ParameterValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParameterValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParameterValue(type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ParameterValue, some of required attributes are not set " + attributes;
    }
  }
}
