package zeenea.connector.matillion.etl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Parameter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParameter.builder()}.
 */
@Generated(from = "Parameter", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableParameter implements Parameter {
  private final String name;
  private final List<List<ParameterValue>> value;

  private ImmutableParameter(
      String name,
      List<List<ParameterValue>> value) {
    this.name = name;
    this.value = value;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public List<List<ParameterValue>> value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableParameter(newValue, this.value);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Parameter#value() value}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableParameter withValue(List<ParameterValue>... elements) {
    List<List<ParameterValue>> newValue = List.of(elements);
    return new ImmutableParameter(this.name, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Parameter#value() value}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of value elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameter withValue(Iterable<? extends List<ParameterValue>> elements) {
    if (this.value == elements) return this;
    List<List<ParameterValue>> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends List<ParameterValue>>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableParameter(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameter
        && equalTo(0, (ImmutableParameter) another);
  }

  private boolean equalTo(int synthetic, ImmutableParameter another) {
    return name.equals(another.name)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Parameter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Parameter{"
        + "name=" + name
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Parameter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Parameter instance
   */
  public static ImmutableParameter copyOf(Parameter instance) {
    if (instance instanceof ImmutableParameter) {
      return (ImmutableParameter) instance;
    }
    return ImmutableParameter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParameter ImmutableParameter}.
   * <pre>
   * ImmutableParameter.builder()
   *    .name(String) // required {@link Parameter#name() name}
   *    .addValue|addAllValue(List&amp;lt;zeenea.connector.matillion.etl.ParameterValue&amp;gt;) // {@link Parameter#value() value} elements
   *    .build();
   * </pre>
   * @return A new ImmutableParameter builder
   */
  public static ImmutableParameter.Builder builder() {
    return new ImmutableParameter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParameter ImmutableParameter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Parameter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private List<List<ParameterValue>> value = new ArrayList<List<ParameterValue>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Parameter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Parameter instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      addAllValue(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link Parameter#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Parameter#value() value} list.
     * @param element A value element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValue(List<ParameterValue> element) {
      this.value.add(Objects.requireNonNull(element, "value element"));
      return this;
    }

    /**
     * Adds elements to {@link Parameter#value() value} list.
     * @param elements An array of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addValue(List<ParameterValue>... elements) {
      for (List<ParameterValue> element : elements) {
        this.value.add(Objects.requireNonNull(element, "value element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Parameter#value() value} list.
     * @param elements An iterable of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(Iterable<? extends List<ParameterValue>> elements) {
      this.value.clear();
      return addAllValue(elements);
    }

    /**
     * Adds elements to {@link Parameter#value() value} list.
     * @param elements An iterable of value elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValue(Iterable<? extends List<ParameterValue>> elements) {
      for (List<ParameterValue> element : elements) {
        this.value.add(Objects.requireNonNull(element, "value element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableParameter ImmutableParameter}.
     * @return An immutable instance of Parameter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParameter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParameter(name, List.copyOf(value));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Parameter, some of required attributes are not set " + attributes;
    }
  }
}
