package zeenea.connector.matillion.etl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link JobCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobCtx.builder()}.
 */
@Generated(from = "JobCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableJobCtx implements JobCtx {
  @NotNull
  private final VersionCtx versionCtx;
  @NotNull
  private final String jobName;

  private ImmutableJobCtx(VersionCtx versionCtx, String jobName) {
    this.versionCtx = versionCtx;
    this.jobName = jobName;
  }

  /**
   * @return The value of the {@code versionCtx} attribute
   */
  @JsonProperty("versionCtx")
  @NotNull
  @Override
  public VersionCtx versionCtx() {
    return versionCtx;
  }

  /**
   * @return The value of the {@code jobName} attribute
   */
  @JsonProperty("jobName")
  @NotNull
  @Override
  public String jobName() {
    return jobName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobCtx#versionCtx() versionCtx} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for versionCtx
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobCtx withVersionCtx(VersionCtx value) {
    if (this.versionCtx == value) return this;
    VersionCtx newValue = Objects.requireNonNull(value, "versionCtx");
    return new ImmutableJobCtx(newValue, this.jobName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobCtx#jobName() jobName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jobName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobCtx withJobName(String value) {
    String newValue = Objects.requireNonNull(value, "jobName");
    if (this.jobName.equals(newValue)) return this;
    return new ImmutableJobCtx(this.versionCtx, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobCtx
        && equalTo(0, (ImmutableJobCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobCtx another) {
    return versionCtx.equals(another.versionCtx)
        && jobName.equals(another.jobName);
  }

  /**
   * Computes a hash code from attributes: {@code versionCtx}, {@code jobName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + versionCtx.hashCode();
    h += (h << 5) + jobName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JobCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobCtx{"
        + "versionCtx=" + versionCtx
        + ", jobName=" + jobName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JobCtx", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JobCtx {
    @Nullable VersionCtx versionCtx;
    @Nullable String jobName;
    @JsonProperty("versionCtx")
    public void setVersionCtx(VersionCtx versionCtx) {
      this.versionCtx = versionCtx;
    }
    @JsonProperty("jobName")
    public void setJobName(String jobName) {
      this.jobName = jobName;
    }
    @Override
    public VersionCtx versionCtx() { throw new UnsupportedOperationException(); }
    @Override
    public String jobName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJobCtx fromJson(Json json) {
    ImmutableJobCtx.Builder builder = ImmutableJobCtx.builder();
    if (json.versionCtx != null) {
      builder.versionCtx(json.versionCtx);
    }
    if (json.jobName != null) {
      builder.jobName(json.jobName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JobCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobCtx instance
   */
  public static ImmutableJobCtx copyOf(JobCtx instance) {
    if (instance instanceof ImmutableJobCtx) {
      return (ImmutableJobCtx) instance;
    }
    return ImmutableJobCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobCtx ImmutableJobCtx}.
   * <pre>
   * ImmutableJobCtx.builder()
   *    .versionCtx(zeenea.connector.matillion.etl.VersionCtx) // required {@link JobCtx#versionCtx() versionCtx}
   *    .jobName(String) // required {@link JobCtx#jobName() jobName}
   *    .build();
   * </pre>
   * @return A new ImmutableJobCtx builder
   */
  public static ImmutableJobCtx.Builder builder() {
    return new ImmutableJobCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobCtx ImmutableJobCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERSION_CTX = 0x1L;
    private static final long INIT_BIT_JOB_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable VersionCtx versionCtx;
    private @Nullable String jobName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JobCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.versionCtx(instance.versionCtx());
      this.jobName(instance.jobName());
      return this;
    }

    /**
     * Initializes the value for the {@link JobCtx#versionCtx() versionCtx} attribute.
     * @param versionCtx The value for versionCtx 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("versionCtx")
    public final Builder versionCtx(VersionCtx versionCtx) {
      this.versionCtx = Objects.requireNonNull(versionCtx, "versionCtx");
      initBits &= ~INIT_BIT_VERSION_CTX;
      return this;
    }

    /**
     * Initializes the value for the {@link JobCtx#jobName() jobName} attribute.
     * @param jobName The value for jobName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jobName")
    public final Builder jobName(String jobName) {
      this.jobName = Objects.requireNonNull(jobName, "jobName");
      initBits &= ~INIT_BIT_JOB_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobCtx ImmutableJobCtx}.
     * @return An immutable instance of JobCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJobCtx(versionCtx, jobName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION_CTX) != 0) attributes.add("versionCtx");
      if ((initBits & INIT_BIT_JOB_NAME) != 0) attributes.add("jobName");
      return "Cannot build JobCtx, some of required attributes are not set " + attributes;
    }
  }
}
