package zeenea.connector.matillion.etl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link GroupCtx}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroupCtx.builder()}.
 */
@Generated(from = "GroupCtx", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableGroupCtx implements GroupCtx {
  @NotNull
  private final String groupName;

  private ImmutableGroupCtx(String groupName) {
    this.groupName = groupName;
  }

  /**
   * @return The value of the {@code groupName} attribute
   */
  @JsonProperty("groupName")
  @NotNull
  @Override
  public String groupName() {
    return groupName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupCtx#groupName() groupName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupCtx withGroupName(String value) {
    String newValue = Objects.requireNonNull(value, "groupName");
    if (this.groupName.equals(newValue)) return this;
    return new ImmutableGroupCtx(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroupCtx} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroupCtx
        && equalTo(0, (ImmutableGroupCtx) another);
  }

  private boolean equalTo(int synthetic, ImmutableGroupCtx another) {
    return groupName.equals(another.groupName);
  }

  /**
   * Computes a hash code from attributes: {@code groupName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GroupCtx} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GroupCtx{"
        + "groupName=" + groupName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GroupCtx", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements GroupCtx {
    @Nullable String groupName;
    @JsonProperty("groupName")
    public void setGroupName(String groupName) {
      this.groupName = groupName;
    }
    @Override
    public String groupName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGroupCtx fromJson(Json json) {
    ImmutableGroupCtx.Builder builder = ImmutableGroupCtx.builder();
    if (json.groupName != null) {
      builder.groupName(json.groupName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GroupCtx} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GroupCtx instance
   */
  public static ImmutableGroupCtx copyOf(GroupCtx instance) {
    if (instance instanceof ImmutableGroupCtx) {
      return (ImmutableGroupCtx) instance;
    }
    return ImmutableGroupCtx.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroupCtx ImmutableGroupCtx}.
   * <pre>
   * ImmutableGroupCtx.builder()
   *    .groupName(String) // required {@link GroupCtx#groupName() groupName}
   *    .build();
   * </pre>
   * @return A new ImmutableGroupCtx builder
   */
  public static ImmutableGroupCtx.Builder builder() {
    return new ImmutableGroupCtx.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroupCtx ImmutableGroupCtx}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GroupCtx", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GROUP_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String groupName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GroupCtx} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GroupCtx instance) {
      Objects.requireNonNull(instance, "instance");
      this.groupName(instance.groupName());
      return this;
    }

    /**
     * Initializes the value for the {@link GroupCtx#groupName() groupName} attribute.
     * @param groupName The value for groupName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupName")
    public final Builder groupName(String groupName) {
      this.groupName = Objects.requireNonNull(groupName, "groupName");
      initBits &= ~INIT_BIT_GROUP_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroupCtx ImmutableGroupCtx}.
     * @return An immutable instance of GroupCtx
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroupCtx build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroupCtx(groupName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_NAME) != 0) attributes.add("groupName");
      return "Cannot build GroupCtx, some of required attributes are not set " + attributes;
    }
  }
}
