package zeenea.connector.matillion.etl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.commons.db.DbTable;

/**
 * Immutable implementation of {@link DatasetLink}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDatasetLink.builder()}.
 */
@Generated(from = "DatasetLink", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDatasetLink implements DatasetLink {
  private final DbTable ref;
  private final LinkDirection direction;

  private ImmutableDatasetLink(DbTable ref, LinkDirection direction) {
    this.ref = ref;
    this.direction = direction;
  }

  /**
   * @return The value of the {@code ref} attribute
   */
  @Override
  public DbTable ref() {
    return ref;
  }

  /**
   * @return The value of the {@code direction} attribute
   */
  @Override
  public LinkDirection direction() {
    return direction;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetLink#ref() ref} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetLink withRef(DbTable value) {
    if (this.ref == value) return this;
    DbTable newValue = Objects.requireNonNull(value, "ref");
    return new ImmutableDatasetLink(newValue, this.direction);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DatasetLink#direction() direction} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for direction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetLink withDirection(LinkDirection value) {
    LinkDirection newValue = Objects.requireNonNull(value, "direction");
    if (this.direction == newValue) return this;
    return new ImmutableDatasetLink(this.ref, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetLink
        && equalTo(0, (ImmutableDatasetLink) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetLink another) {
    return ref.equals(another.ref)
        && direction.equals(another.direction);
  }

  /**
   * Computes a hash code from attributes: {@code ref}, {@code direction}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + ref.hashCode();
    h += (h << 5) + direction.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DatasetLink{"
        + "ref=" + ref
        + ", direction=" + direction
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DatasetLink} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetLink instance
   */
  public static ImmutableDatasetLink copyOf(DatasetLink instance) {
    if (instance instanceof ImmutableDatasetLink) {
      return (ImmutableDatasetLink) instance;
    }
    return ImmutableDatasetLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDatasetLink ImmutableDatasetLink}.
   * <pre>
   * ImmutableDatasetLink.builder()
   *    .ref(zeenea.connector.commons.db.DbTable) // required {@link DatasetLink#ref() ref}
   *    .direction(zeenea.connector.matillion.etl.LinkDirection) // required {@link DatasetLink#direction() direction}
   *    .build();
   * </pre>
   * @return A new ImmutableDatasetLink builder
   */
  public static ImmutableDatasetLink.Builder builder() {
    return new ImmutableDatasetLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetLink ImmutableDatasetLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DatasetLink", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REF = 0x1L;
    private static final long INIT_BIT_DIRECTION = 0x2L;
    private long initBits = 0x3L;

    private @Nullable DbTable ref;
    private @Nullable LinkDirection direction;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DatasetLink instance) {
      Objects.requireNonNull(instance, "instance");
      this.ref(instance.ref());
      this.direction(instance.direction());
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetLink#ref() ref} attribute.
     * @param ref The value for ref 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ref(DbTable ref) {
      this.ref = Objects.requireNonNull(ref, "ref");
      initBits &= ~INIT_BIT_REF;
      return this;
    }

    /**
     * Initializes the value for the {@link DatasetLink#direction() direction} attribute.
     * @param direction The value for direction 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder direction(LinkDirection direction) {
      this.direction = Objects.requireNonNull(direction, "direction");
      initBits &= ~INIT_BIT_DIRECTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDatasetLink ImmutableDatasetLink}.
     * @return An immutable instance of DatasetLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatasetLink(ref, direction);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REF) != 0) attributes.add("ref");
      if ((initBits & INIT_BIT_DIRECTION) != 0) attributes.add("direction");
      return "Cannot build DatasetLink, some of required attributes are not set " + attributes;
    }
  }
}
