package zeenea.connector.matillion.etl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.matillion.etl.client.EnvironmentJson;

/**
 * Immutable implementation of {@link Context}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContext.builder()}.
 */
@Generated(from = "Context", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableContext implements Context {
  private final Platform platform;
  private final TracingContext ctx;
  private final EnvironmentJson environment;
  private final VariableHandler variables;
  private final ComponentHandler components;

  private ImmutableContext(
      Platform platform,
      TracingContext ctx,
      EnvironmentJson environment,
      VariableHandler variables,
      ComponentHandler components) {
    this.platform = platform;
    this.ctx = ctx;
    this.environment = environment;
    this.variables = variables;
    this.components = components;
  }

  /**
   * @return The value of the {@code platform} attribute
   */
  @Override
  public Platform platform() {
    return platform;
  }

  /**
   * @return The value of the {@code ctx} attribute
   */
  @Override
  public TracingContext ctx() {
    return ctx;
  }

  /**
   * @return The value of the {@code environment} attribute
   */
  @Override
  public EnvironmentJson environment() {
    return environment;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @Override
  public VariableHandler variables() {
    return variables;
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public ComponentHandler components() {
    return components;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#platform() platform} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for platform
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withPlatform(Platform value) {
    Platform newValue = Objects.requireNonNull(value, "platform");
    if (this.platform == newValue) return this;
    return new ImmutableContext(newValue, this.ctx, this.environment, this.variables, this.components);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#ctx() ctx} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ctx
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withCtx(TracingContext value) {
    if (this.ctx == value) return this;
    TracingContext newValue = Objects.requireNonNull(value, "ctx");
    return new ImmutableContext(this.platform, newValue, this.environment, this.variables, this.components);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#environment() environment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for environment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withEnvironment(EnvironmentJson value) {
    if (this.environment == value) return this;
    EnvironmentJson newValue = Objects.requireNonNull(value, "environment");
    return new ImmutableContext(this.platform, this.ctx, newValue, this.variables, this.components);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#variables() variables} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for variables
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withVariables(VariableHandler value) {
    if (this.variables == value) return this;
    VariableHandler newValue = Objects.requireNonNull(value, "variables");
    return new ImmutableContext(this.platform, this.ctx, this.environment, newValue, this.components);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Context#components() components} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for components
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContext withComponents(ComponentHandler value) {
    if (this.components == value) return this;
    ComponentHandler newValue = Objects.requireNonNull(value, "components");
    return new ImmutableContext(this.platform, this.ctx, this.environment, this.variables, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContext
        && equalTo(0, (ImmutableContext) another);
  }

  private boolean equalTo(int synthetic, ImmutableContext another) {
    return platform.equals(another.platform)
        && ctx.equals(another.ctx)
        && environment.equals(another.environment)
        && variables.equals(another.variables)
        && components.equals(another.components);
  }

  /**
   * Computes a hash code from attributes: {@code platform}, {@code ctx}, {@code environment}, {@code variables}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + platform.hashCode();
    h += (h << 5) + ctx.hashCode();
    h += (h << 5) + environment.hashCode();
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + components.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Context} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Context{"
        + "platform=" + platform
        + ", ctx=" + ctx
        + ", environment=" + environment
        + ", variables=" + variables
        + ", components=" + components
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Context} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Context instance
   */
  public static ImmutableContext copyOf(Context instance) {
    if (instance instanceof ImmutableContext) {
      return (ImmutableContext) instance;
    }
    return ImmutableContext.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContext ImmutableContext}.
   * <pre>
   * ImmutableContext.builder()
   *    .platform(zeenea.connector.matillion.etl.Platform) // required {@link Context#platform() platform}
   *    .ctx(zeenea.connector.commons.log.TracingContext) // required {@link Context#ctx() ctx}
   *    .environment(zeenea.connector.matillion.etl.client.EnvironmentJson) // required {@link Context#environment() environment}
   *    .variables(zeenea.connector.matillion.etl.VariableHandler) // required {@link Context#variables() variables}
   *    .components(zeenea.connector.matillion.etl.ComponentHandler) // required {@link Context#components() components}
   *    .build();
   * </pre>
   * @return A new ImmutableContext builder
   */
  public static ImmutableContext.Builder builder() {
    return new ImmutableContext.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContext ImmutableContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Context", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLATFORM = 0x1L;
    private static final long INIT_BIT_CTX = 0x2L;
    private static final long INIT_BIT_ENVIRONMENT = 0x4L;
    private static final long INIT_BIT_VARIABLES = 0x8L;
    private static final long INIT_BIT_COMPONENTS = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable Platform platform;
    private @Nullable TracingContext ctx;
    private @Nullable EnvironmentJson environment;
    private @Nullable VariableHandler variables;
    private @Nullable ComponentHandler components;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Context} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Context instance) {
      Objects.requireNonNull(instance, "instance");
      this.platform(instance.platform());
      this.ctx(instance.ctx());
      this.environment(instance.environment());
      this.variables(instance.variables());
      this.components(instance.components());
      return this;
    }

    /**
     * Initializes the value for the {@link Context#platform() platform} attribute.
     * @param platform The value for platform 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder platform(Platform platform) {
      this.platform = Objects.requireNonNull(platform, "platform");
      initBits &= ~INIT_BIT_PLATFORM;
      return this;
    }

    /**
     * Initializes the value for the {@link Context#ctx() ctx} attribute.
     * @param ctx The value for ctx 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ctx(TracingContext ctx) {
      this.ctx = Objects.requireNonNull(ctx, "ctx");
      initBits &= ~INIT_BIT_CTX;
      return this;
    }

    /**
     * Initializes the value for the {@link Context#environment() environment} attribute.
     * @param environment The value for environment 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environment(EnvironmentJson environment) {
      this.environment = Objects.requireNonNull(environment, "environment");
      initBits &= ~INIT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link Context#variables() variables} attribute.
     * @param variables The value for variables 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variables(VariableHandler variables) {
      this.variables = Objects.requireNonNull(variables, "variables");
      initBits &= ~INIT_BIT_VARIABLES;
      return this;
    }

    /**
     * Initializes the value for the {@link Context#components() components} attribute.
     * @param components The value for components 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder components(ComponentHandler components) {
      this.components = Objects.requireNonNull(components, "components");
      initBits &= ~INIT_BIT_COMPONENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContext ImmutableContext}.
     * @return An immutable instance of Context
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContext build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContext(platform, ctx, environment, variables, components);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PLATFORM) != 0) attributes.add("platform");
      if ((initBits & INIT_BIT_CTX) != 0) attributes.add("ctx");
      if ((initBits & INIT_BIT_ENVIRONMENT) != 0) attributes.add("environment");
      if ((initBits & INIT_BIT_VARIABLES) != 0) attributes.add("variables");
      if ((initBits & INIT_BIT_COMPONENTS) != 0) attributes.add("components");
      return "Cannot build Context, some of required attributes are not set " + attributes;
    }
  }
}
