package zeenea.connector.matillion.etl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import zeenea.connector.matillion.etl.client.Cardinality;

/**
 * Immutable implementation of {@link Component}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableComponent.builder()}.
 */
@Generated(from = "Component", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableComponent implements Component {
  private final long id;
  private final Cardinality inputCardinality;
  private final Cardinality outputCardinality;
  private final Map<String, Parameter> parameters;

  private ImmutableComponent(ImmutableComponent.Builder builder) {
    this.id = builder.id;
    this.inputCardinality = builder.inputCardinality;
    this.outputCardinality = builder.outputCardinality;
    this.parameters = builder.parametersIsSet()
        ? createUnmodifiableMap(false, false, builder.parameters)
        : createUnmodifiableMap(true, false, Component.super.parameters());
  }

  private ImmutableComponent(
      long id,
      Cardinality inputCardinality,
      Cardinality outputCardinality,
      Map<String, Parameter> parameters) {
    this.id = id;
    this.inputCardinality = inputCardinality;
    this.outputCardinality = outputCardinality;
    this.parameters = parameters;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public long id() {
    return id;
  }

  /**
   * @return The value of the {@code inputCardinality} attribute
   */
  @Override
  public Cardinality inputCardinality() {
    return inputCardinality;
  }

  /**
   * @return The value of the {@code outputCardinality} attribute
   */
  @Override
  public Cardinality outputCardinality() {
    return outputCardinality;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public Map<String, Parameter> parameters() {
    return parameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Component#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponent withId(long value) {
    if (this.id == value) return this;
    return new ImmutableComponent(value, this.inputCardinality, this.outputCardinality, this.parameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Component#inputCardinality() inputCardinality} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputCardinality
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponent withInputCardinality(Cardinality value) {
    Cardinality newValue = Objects.requireNonNull(value, "inputCardinality");
    if (this.inputCardinality == newValue) return this;
    return new ImmutableComponent(this.id, newValue, this.outputCardinality, this.parameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Component#outputCardinality() outputCardinality} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputCardinality
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableComponent withOutputCardinality(Cardinality value) {
    Cardinality newValue = Objects.requireNonNull(value, "outputCardinality");
    if (this.outputCardinality == newValue) return this;
    return new ImmutableComponent(this.id, this.inputCardinality, newValue, this.parameters);
  }

  /**
   * Copy the current immutable object by replacing the {@link Component#parameters() parameters} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the parameters map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableComponent withParameters(Map<String, ? extends Parameter> entries) {
    if (this.parameters == entries) return this;
    Map<String, Parameter> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableComponent(this.id, this.inputCardinality, this.outputCardinality, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableComponent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableComponent
        && equalTo(0, (ImmutableComponent) another);
  }

  private boolean equalTo(int synthetic, ImmutableComponent another) {
    return id == another.id
        && inputCardinality.equals(another.inputCardinality)
        && outputCardinality.equals(another.outputCardinality)
        && parameters.equals(another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code inputCardinality}, {@code outputCardinality}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(id);
    h += (h << 5) + inputCardinality.hashCode();
    h += (h << 5) + outputCardinality.hashCode();
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Component} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Component{"
        + "id=" + id
        + ", inputCardinality=" + inputCardinality
        + ", outputCardinality=" + outputCardinality
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Component} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Component instance
   */
  public static ImmutableComponent copyOf(Component instance) {
    if (instance instanceof ImmutableComponent) {
      return (ImmutableComponent) instance;
    }
    return ImmutableComponent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableComponent ImmutableComponent}.
   * <pre>
   * ImmutableComponent.builder()
   *    .id(long) // required {@link Component#id() id}
   *    .inputCardinality(zeenea.connector.matillion.etl.client.Cardinality) // required {@link Component#inputCardinality() inputCardinality}
   *    .outputCardinality(zeenea.connector.matillion.etl.client.Cardinality) // required {@link Component#outputCardinality() outputCardinality}
   *    .putParameters|putAllParameters(String =&gt; zeenea.connector.matillion.etl.Parameter) // {@link Component#parameters() parameters} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableComponent builder
   */
  public static ImmutableComponent.Builder builder() {
    return new ImmutableComponent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableComponent ImmutableComponent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Component", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_INPUT_CARDINALITY = 0x2L;
    private static final long INIT_BIT_OUTPUT_CARDINALITY = 0x4L;
    private static final long OPT_BIT_PARAMETERS = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private long id;
    private @Nullable Cardinality inputCardinality;
    private @Nullable Cardinality outputCardinality;
    private Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Component} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Component instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.id());
      this.inputCardinality(instance.inputCardinality());
      this.outputCardinality(instance.outputCardinality());
      putAllParameters(instance.parameters());
      return this;
    }

    /**
     * Initializes the value for the {@link Component#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(long id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Component#inputCardinality() inputCardinality} attribute.
     * @param inputCardinality The value for inputCardinality 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inputCardinality(Cardinality inputCardinality) {
      this.inputCardinality = Objects.requireNonNull(inputCardinality, "inputCardinality");
      initBits &= ~INIT_BIT_INPUT_CARDINALITY;
      return this;
    }

    /**
     * Initializes the value for the {@link Component#outputCardinality() outputCardinality} attribute.
     * @param outputCardinality The value for outputCardinality 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputCardinality(Cardinality outputCardinality) {
      this.outputCardinality = Objects.requireNonNull(outputCardinality, "outputCardinality");
      initBits &= ~INIT_BIT_OUTPUT_CARDINALITY;
      return this;
    }

    /**
     * Put one entry to the {@link Component#parameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParameters(String key, Parameter value) {
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, value == null ? "parameters value for key: " + key : null));
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Put one entry to the {@link Component#parameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putParameters(Map.Entry<String, ? extends Parameter> entry) {
      String k = entry.getKey();
      Parameter v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Component#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(Map<String, ? extends Parameter> entries) {
      this.parameters.clear();
      optBits |= OPT_BIT_PARAMETERS;
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Component#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Parameter> entries) {
      for (Map.Entry<String, ? extends Parameter> e : entries.entrySet()) {
        String k = e.getKey();
        Parameter v = e.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, v == null ? "parameters value for key: " + k : null));
      }
      optBits |= OPT_BIT_PARAMETERS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableComponent ImmutableComponent}.
     * @return An immutable instance of Component
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableComponent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableComponent(this);
    }

    private boolean parametersIsSet() {
      return (optBits & OPT_BIT_PARAMETERS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INPUT_CARDINALITY) != 0) attributes.add("inputCardinality");
      if ((initBits & INIT_BIT_OUTPUT_CARDINALITY) != 0) attributes.add("outputCardinality");
      return "Cannot build Component, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
