/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.auth.Credentials;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.GsConfig;
import zeenea.connector.commons.proxy.Proxy;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GsConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGsConfig
extends GsConfig {
    @Nullable
    private final Proxy proxy;
    private final Credentials credentials;
    private final String projectId;

    private ImmutableGsConfig(@Nullable Proxy proxy, Credentials credentials, String projectId) {
        this.proxy = proxy;
        this.credentials = credentials;
        this.projectId = projectId;
    }

    @Override
    @Nullable
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    @Override
    public String projectId() {
        return this.projectId;
    }

    public final ImmutableGsConfig withProxy(@Nullable Proxy value) {
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableGsConfig(value, this.credentials, this.projectId);
    }

    public final ImmutableGsConfig withCredentials(Credentials value) {
        if (this.credentials == value) {
            return this;
        }
        Credentials newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableGsConfig(this.proxy, newValue, this.projectId);
    }

    public final ImmutableGsConfig withProjectId(String value) {
        String newValue = Objects.requireNonNull(value, "projectId");
        if (this.projectId.equals(newValue)) {
            return this;
        }
        return new ImmutableGsConfig(this.proxy, this.credentials, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGsConfig && this.equalTo(0, (ImmutableGsConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGsConfig another) {
        return Objects.equals(this.proxy, another.proxy) && this.credentials.equals(another.credentials) && this.projectId.equals(another.projectId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.proxy);
        h += (h << 5) + this.credentials.hashCode();
        h += (h << 5) + this.projectId.hashCode();
        return h;
    }

    public String toString() {
        return "GsConfig{proxy=" + String.valueOf(this.proxy) + ", credentials=" + String.valueOf(this.credentials) + ", projectId=" + this.projectId + "}";
    }

    public static ImmutableGsConfig copyOf(GsConfig instance) {
        if (instance instanceof ImmutableGsConfig) {
            return (ImmutableGsConfig)instance;
        }
        return ImmutableGsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CREDENTIALS = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private long initBits = 3L;
        @javax.annotation.Nullable
        private Proxy proxy;
        @javax.annotation.Nullable
        private Credentials credentials;
        @javax.annotation.Nullable
        private String projectId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            @Nullable Proxy proxyValue = instance.proxy();
            if (proxyValue != null) {
                this.proxy(proxyValue);
            }
            this.credentials(instance.credentials());
            this.projectId(instance.projectId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Credentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectId(String projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGsConfig(this.proxy, this.credentials, this.projectId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("credentials");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            return "Cannot build GsConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

