/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.Adls2Config;
import zeenea.connector.commons.proxy.Proxy;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Adls2Config", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAdls2Config
extends Adls2Config {
    @Nullable
    private final String tenantId;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;
    @Nullable
    private final String accountName;
    @Nullable
    private final String accountKey;
    @Nullable
    private final Proxy proxy;

    private ImmutableAdls2Config(@Nullable String tenantId, @Nullable String clientId, @Nullable String clientSecret, @Nullable String accountName, @Nullable String accountKey, @Nullable Proxy proxy) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.accountName = accountName;
        this.accountKey = accountKey;
        this.proxy = proxy;
    }

    @Override
    @Nullable
    public String tenantId() {
        return this.tenantId;
    }

    @Override
    @Nullable
    public String clientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    @Nullable
    public String accountName() {
        return this.accountName;
    }

    @Override
    @Nullable
    public String accountKey() {
        return this.accountKey;
    }

    @Override
    @Nullable
    public Proxy proxy() {
        return this.proxy;
    }

    public final ImmutableAdls2Config withTenantId(@Nullable String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableAdls2Config(value, this.clientId, this.clientSecret, this.accountName, this.accountKey, this.proxy);
    }

    public final ImmutableAdls2Config withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableAdls2Config(this.tenantId, value, this.clientSecret, this.accountName, this.accountKey, this.proxy);
    }

    public final ImmutableAdls2Config withClientSecret(@Nullable String value) {
        if (Objects.equals(this.clientSecret, value)) {
            return this;
        }
        return new ImmutableAdls2Config(this.tenantId, this.clientId, value, this.accountName, this.accountKey, this.proxy);
    }

    public final ImmutableAdls2Config withAccountName(@Nullable String value) {
        if (Objects.equals(this.accountName, value)) {
            return this;
        }
        return new ImmutableAdls2Config(this.tenantId, this.clientId, this.clientSecret, value, this.accountKey, this.proxy);
    }

    public final ImmutableAdls2Config withAccountKey(@Nullable String value) {
        if (Objects.equals(this.accountKey, value)) {
            return this;
        }
        return new ImmutableAdls2Config(this.tenantId, this.clientId, this.clientSecret, this.accountName, value, this.proxy);
    }

    public final ImmutableAdls2Config withProxy(@Nullable Proxy value) {
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableAdls2Config(this.tenantId, this.clientId, this.clientSecret, this.accountName, this.accountKey, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdls2Config && this.equalTo(0, (ImmutableAdls2Config)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdls2Config another) {
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.accountName, another.accountName) && Objects.equals(this.accountKey, another.accountKey) && Objects.equals(this.proxy, another.proxy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + Objects.hashCode(this.clientSecret);
        h += (h << 5) + Objects.hashCode(this.accountName);
        h += (h << 5) + Objects.hashCode(this.accountKey);
        h += (h << 5) + Objects.hashCode(this.proxy);
        return h;
    }

    public String toString() {
        return "Adls2Config{tenantId=" + this.tenantId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", accountName=" + this.accountName + ", accountKey=" + this.accountKey + ", proxy=" + String.valueOf(this.proxy) + "}";
    }

    public static ImmutableAdls2Config copyOf(Adls2Config instance) {
        if (instance instanceof ImmutableAdls2Config) {
            return (ImmutableAdls2Config)instance;
        }
        return ImmutableAdls2Config.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Adls2Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @javax.annotation.Nullable
        private String tenantId;
        @javax.annotation.Nullable
        private String clientId;
        @javax.annotation.Nullable
        private String clientSecret;
        @javax.annotation.Nullable
        private String accountName;
        @javax.annotation.Nullable
        private String accountKey;
        @javax.annotation.Nullable
        private Proxy proxy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Adls2Config instance) {
            Proxy proxyValue;
            String accountKeyValue;
            String accountNameValue;
            String clientSecretValue;
            String clientIdValue;
            Objects.requireNonNull(instance, "instance");
            @Nullable String tenantIdValue = instance.tenantId();
            if (tenantIdValue != null) {
                this.tenantId(tenantIdValue);
            }
            if ((clientIdValue = instance.clientId()) != null) {
                this.clientId(clientIdValue);
            }
            if ((clientSecretValue = instance.clientSecret()) != null) {
                this.clientSecret(clientSecretValue);
            }
            if ((accountNameValue = instance.accountName()) != null) {
                this.accountName(accountNameValue);
            }
            if ((accountKeyValue = instance.accountKey()) != null) {
                this.accountKey(accountKeyValue);
            }
            if ((proxyValue = instance.proxy()) != null) {
                this.proxy(proxyValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountName(@Nullable String accountName) {
            this.accountName = accountName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountKey(@Nullable String accountKey) {
            this.accountKey = accountKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public ImmutableAdls2Config build() {
            return new ImmutableAdls2Config(this.tenantId, this.clientId, this.clientSecret, this.accountName, this.accountKey, this.proxy);
        }
    }
}

