/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.gax.paging.Page;
import com.google.cloud.ReadChannel;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import zeenea.connector.commons.fsclient.BucketFsUrl;
import zeenea.connector.commons.fsclient.FsClient;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.fsclient.GsConfig;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;

public final class GsFsClient
extends FsClient {
    private static final SimpleLogger log = SimpleLogger.of(GsFsClient.class);
    private final Storage storage;

    private GsFsClient(Storage storage) {
        this.storage = storage;
    }

    public static GsFsClient create(GsConfig config) {
        StorageOptions.Builder storageOptions = (StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(config.projectId())).setCredentials(config.credentials());
        Proxy proxy = config.proxy();
        if (proxy != null) {
            HttpTransportOptions transportOptions = HttpTransportOptions.newBuilder().setHttpTransportFactory(() -> GsFsClient.createHttpTransport(proxy)).build();
            storageOptions.setTransportOptions((TransportOptions)transportOptions);
        }
        Storage storage = (Storage)storageOptions.build().getService();
        return new GsFsClient(storage);
    }

    private static HttpTransport createHttpTransport(Proxy proxy) {
        HttpClientBuilder builder = ApacheHttpTransport.newDefaultHttpClientBuilder();
        builder.setProxy(new HttpHost(proxy.getHostname(), proxy.getPort()));
        String usename = proxy.getUsername();
        String password = proxy.getPassword();
        if (usename != null && password != null) {
            BasicCredentialsProvider cp = new BasicCredentialsProvider();
            cp.setCredentials(new AuthScope(proxy.getHostname(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(usename, password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)cp);
        }
        return new ApacheHttpTransport((HttpClient)builder.build());
    }

    @Override
    public Stream<FsPath> listFiles(TracingContext ctx, FsUrl url) {
        Storage.BlobListOption[] blobListOptionArray;
        log.entry("fs_client_gs_list_files").context(ctx).with("url", (Object)url).debug();
        BucketFsUrl gsUrl = GsFsClient.checkUrl(ctx, url);
        FsPath prefix = gsUrl.path();
        if (!prefix.isEmpty()) {
            Storage.BlobListOption[] blobListOptionArray2 = new Storage.BlobListOption[1];
            blobListOptionArray = blobListOptionArray2;
            blobListOptionArray2[0] = Storage.BlobListOption.prefix((String)(String.valueOf(prefix) + "/"));
        } else {
            blobListOptionArray = new Storage.BlobListOption[]{};
        }
        Storage.BlobListOption[] options = blobListOptionArray;
        Page list = this.storage.list(gsUrl.bucket(), options);
        return list.streamAll().map(blob -> prefix.relativize(FsPath.of(blob.getBlobId().getName())));
    }

    @Override
    public InputStream inputStream(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_gs_input_stream").context(ctx).with("url", (Object)url).debug();
        BucketFsUrl gsUrl = GsFsClient.checkUrl(ctx, url);
        BlobId blobId = BlobId.of((String)gsUrl.bucket(), (String)url.path().toString());
        Blob blob = this.storage.get(blobId);
        if (blob == null || !blob.exists(new Blob.BlobSourceOption[0])) {
            return null;
        }
        ReadChannel reader = this.storage.reader(blobId, new Storage.BlobSourceOption[0]);
        return Channels.newInputStream((ReadableByteChannel)reader);
    }

    private static BucketFsUrl checkUrl(TracingContext ctx, FsUrl url) {
        if (!(url instanceof BucketFsUrl) || url.fsName() != FsName.GS) {
            throw (IllegalArgumentException)log.entry("fs_client_gs_unsupported_url").context(ctx).with("url", (Object)url).with("class", (Object)url.getClass().getName()).exception(IllegalArgumentException::new);
        }
        return (BucketFsUrl)url;
    }

    @Override
    public void close() {
    }
}

