/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.fsclient.Adls2FsUrl;
import zeenea.connector.commons.fsclient.BucketFsUrl;
import zeenea.connector.commons.fsclient.FileFsUrl;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;

public abstract class FsUrl {
    private final FsPath path;

    FsUrl(@NotNull FsPath path) {
        this.path = Objects.requireNonNull(path);
    }

    public abstract FsName fsName();

    public FsPath path() {
        return this.path;
    }

    abstract FsUrl withPath(FsPath var1);

    public FsUrl resolve(FsPath oPath) {
        if (oPath.isEmpty()) {
            return this;
        }
        return this.withPath(this.path.resolve(oPath));
    }

    public FsUrl resolve(String relative) {
        if (relative == null || relative.isEmpty()) {
            return this;
        }
        return this.withPath(this.path.resolve(relative));
    }

    public static FsUrl parse(String url) {
        int protocolIdx = url.indexOf(58);
        if (protocolIdx == 0) {
            throw new IllegalArgumentException("URL can't start with column: '" + url + "'");
        }
        if (protocolIdx < 0 || protocolIdx == 1) {
            return FileFsUrl.of(Path.of(url, new String[0]));
        }
        try {
            String scheme;
            URI uri = new URI(url);
            switch (scheme = Objects.requireNonNull(uri.getScheme(), "scheme is null (should not happen)")) {
                case "file": {
                    return FileFsUrl.of(Path.of(uri));
                }
                case "https": {
                    String host = uri.getHost();
                    if (host == null || host.isEmpty()) {
                        throw new IllegalArgumentException("Host mandatory for " + scheme + " URL: '" + url + "'");
                    }
                    if (host.endsWith(".dfs.core.windows.net") || host.endsWith(".blob.core.windows.net")) {
                        FsPath fullPath = FsUrl.fsPath(uri);
                        if (fullPath.isEmpty()) {
                            throw new IllegalArgumentException("Container mandatory for " + scheme + " URL: '" + url + "'");
                        }
                        FsPath container = fullPath.prefix(1);
                        FsPath path = container.relativize(fullPath);
                        return new Adls2FsUrl(uri.getAuthority(), container.toString(), path);
                    }
                    throw new IllegalArgumentException("Unsupported URL: '" + url + "'");
                }
                case "s3": 
                case "gs": {
                    FsName fsName = scheme.equals("s3") ? FsName.S3 : FsName.GS;
                    String bucket = uri.getAuthority();
                    FsPath fsPath = FsUrl.fsPath(uri);
                    if (bucket == null || bucket.isEmpty()) {
                        throw new IllegalArgumentException("Bucket mandatory for " + scheme + " URL: '" + url + "'");
                    }
                    return new BucketFsUrl(fsName, bucket, fsPath);
                }
            }
            throw new IllegalArgumentException("Unknown schema '" + scheme + "': '" + url + "'");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: '" + url + "'", e);
        }
    }

    private static FsPath fsPath(URI uri) {
        String uriPath = uri.getPath();
        if (uriPath != null && !uriPath.isEmpty() && uriPath.charAt(0) == '/') {
            uriPath = uriPath.substring(1);
        }
        return FsPath.of(uriPath);
    }
}

