/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class FsPath
implements Comparable<FsPath> {
    private static final FsPath EMPTY = new FsPath(List.of());
    private final List<String> path;

    public FsPath(List<String> path) {
        this.path = List.copyOf(path);
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public List<String> path() {
        return this.path;
    }

    public int length() {
        return this.path.size();
    }

    public Optional<String> name() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.path.get(this.path.size() - 1));
    }

    public FsPath resolve(String child) {
        if (child == null || child.isEmpty()) {
            return this;
        }
        return this.resolve(Arrays.asList(child.split("/", -1)), false);
    }

    public FsPath resolve(FsPath child) {
        if (child == null || child.isEmpty()) {
            return this;
        }
        return this.resolve(child.path, false);
    }

    private FsPath resolve(List<String> relative, boolean allowEscape) {
        ArrayList<String> newPath = new ArrayList<String>(this.length() + relative.size());
        newPath.addAll(this.path);
        for (String name : relative) {
            if (".".equals(name)) continue;
            if ("..".equals(name)) {
                if (newPath.isEmpty()) {
                    if (allowEscape) {
                        newPath.add("..");
                        continue;
                    }
                    throw new IllegalArgumentException("relative path '" + String.join((CharSequence)"/", relative) + "' is out of scope from '" + String.valueOf(this) + "'");
                }
                if (allowEscape && newPath.get(newPath.size() - 1).equals("..")) {
                    newPath.add("..");
                    continue;
                }
                newPath.remove(newPath.size() - 1);
                continue;
            }
            newPath.add(name);
        }
        return new FsPath(newPath);
    }

    public FsPath relativize(FsPath child) {
        int common;
        ArrayList<String> relativePath = new ArrayList<String>();
        int minLen = Math.min(this.path.size(), child.path.size());
        for (common = 0; common < minLen && this.path.get(common).equals(child.path.get(common)); ++common) {
        }
        for (int i = this.path.size() - common; i > 0; --i) {
            relativePath.add("..");
        }
        relativePath.addAll(child.path.subList(common, child.path.size()));
        return new FsPath(relativePath);
    }

    public FsPath prefix(int len) {
        if (len > this.length()) {
            throw new IndexOutOfBoundsException("Too large prefix " + len + " > " + this.length());
        }
        if (len == 0) {
            return EMPTY;
        }
        if (len == this.length()) {
            return this;
        }
        return new FsPath(this.path.subList(0, len));
    }

    public boolean isPrefixOf(FsPath that) {
        if (this.length() > that.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.path.get(i).equals(that.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public Optional<FsPath> parent() {
        switch (this.length()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(EMPTY);
            }
        }
        return Optional.of(new FsPath(this.path.subList(0, this.path.size() - 1)));
    }

    public static FsPath of(String path) {
        if (path == null || path.isEmpty()) {
            return EMPTY;
        }
        return EMPTY.resolve(Arrays.asList(path.split("/", -1)), true);
    }

    public static FsPath of(Path path) {
        return new FsPath(StreamSupport.stream(path.spliterator(), false).map(Path::toString).collect(Collectors.toList()));
    }

    public Path toJavaPath() {
        return Paths.get(String.join((CharSequence)"/", this.path), new String[0]);
    }

    public String toString() {
        return String.join((CharSequence)"/", this.path);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FsPath)) {
            return false;
        }
        FsPath fsPath = (FsPath)o;
        return Objects.equals(this.path, fsPath.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public int compareTo(@NotNull FsPath o) {
        int len = Math.min(this.length(), o.length());
        for (int i = 0; i < len; ++i) {
            int cmp = this.path.get(i).compareTo(o.path.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.length() - o.length();
    }
}

