/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.io.InputStream;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.FileFsClient;
import zeenea.connector.commons.fsclient.FsClientException;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.json.JsonMapper;
import zeenea.connector.commons.json.YamlMapper;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;

public abstract class FsClient
implements AutoCloseable {
    private static final SimpleLogger log = SimpleLogger.of(FileFsClient.class);

    public abstract Stream<FsPath> listFiles(TracingContext var1, FsUrl var2);

    public abstract InputStream inputStream(TracingContext var1, FsUrl var2);

    @Override
    public abstract void close();

    @Nullable
    public <T> T readJsonBlob(TracingContext ctx, FsUrl url, Class<T> klass) {
        try {
            InputStream is = this.inputStream(ctx, url);
            return (T)(is != null ? JsonMapper.of().readFromInputStream(is, klass) : null);
        }
        catch (RuntimeException e) {
            throw (FsClientException)log.entry("fs_client_read_json_blob_failure").context(ctx).with("url", (Object)url).with("class", (Object)klass.getName()).exception((Throwable)e, FsClientException::new);
        }
    }

    @Deprecated(since="73", forRemoval=true)
    @Nullable
    public <T> T readYamlBlob(TracingContext ctx, FsUrl url, Class<T> klass) {
        try {
            InputStream is = this.inputStream(ctx, url);
            return (T)(is != null ? YamlMapper.of().readFromInputStream(is, klass) : null);
        }
        catch (RuntimeException e) {
            throw (FsClientException)log.entry("fs_client_read_yaml_blob_failure").context(ctx).with("url", (Object)url).with("class", (Object)klass.getName()).exception((Throwable)e, FsClientException::new);
        }
    }

    public <T> Optional<T> readYamlFile(TracingContext ctx, FsUrl url, Class<T> klass) {
        try {
            InputStream is = this.inputStream(ctx, url);
            return is != null ? Optional.ofNullable(YamlMapper.of().readFromInputStream(is, klass)) : Optional.empty();
        }
        catch (RuntimeException e) {
            throw (FsClientException)log.entry("fs_client_read_yaml_blob_failure").context(ctx).with("url", (Object)url).with("class", (Object)klass.getName()).exception((Throwable)e, FsClientException::new);
        }
    }
}

