/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.nio.file.Path;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;

public class FileFsUrl
extends FsUrl {
    private final String root;

    FileFsUrl(String root, FsPath path) {
        super(path);
        this.root = root;
    }

    public static FileFsUrl of(Path path) {
        Path aPath = path.toAbsolutePath();
        Path root = aPath.getRoot();
        if (root == null) {
            throw new IllegalArgumentException("Absolute path root not found: " + String.valueOf(aPath));
        }
        FsPath filePath = FsPath.of(aPath);
        return new FileFsUrl(root.toString(), filePath);
    }

    @Override
    public FsName fsName() {
        return FsName.FILE;
    }

    public String root() {
        return this.root;
    }

    @Override
    FsUrl withPath(FsPath path) {
        return new FileFsUrl(this.root, path);
    }

    public Path toFilePath() {
        return Path.of(this.root, (String[])this.path().path().toArray(String[]::new));
    }

    public String toString() {
        return this.toFilePath().toUri().toASCIIString();
    }
}

