/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import java.io.InputStream;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.fsclient.Adls2Config;
import zeenea.connector.commons.fsclient.Adls2FsClient;
import zeenea.connector.commons.fsclient.CompositeConfig;
import zeenea.connector.commons.fsclient.FileFsClient;
import zeenea.connector.commons.fsclient.FsClient;
import zeenea.connector.commons.fsclient.FsName;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.fsclient.GsConfig;
import zeenea.connector.commons.fsclient.GsFsClient;
import zeenea.connector.commons.fsclient.S3Config;
import zeenea.connector.commons.fsclient.S3FsClient;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;

public class CompositeFsClient
extends FsClient {
    private static final SimpleLogger log = SimpleLogger.of(CompositeFsClient.class);
    private final EnumMap<FsName, FsClient> clientMap = new EnumMap(FsName.class);

    public CompositeFsClient(Map<FsName, FsClient> clientMap) {
        this.clientMap.putAll(Objects.requireNonNull(clientMap));
    }

    public static CompositeFsClient create(CompositeConfig config) {
        EnumMap<FsName, FsClient> clients = new EnumMap<FsName, FsClient>(FsName.class);
        EnumSet<FsName> enabledFs = config.enabledFs();
        if (enabledFs.contains((Object)FsName.FILE)) {
            clients.put(FsName.FILE, new FileFsClient());
        }
        if (enabledFs.contains((Object)FsName.S3)) {
            S3Config s3Config = config.s3Config();
            if (s3Config == null) {
                throw (IllegalArgumentException)log.entry("fs_client_composite_create_no_s3_config_failure").with("enabled_fs", enabledFs).exception(IllegalArgumentException::new);
            }
            clients.put(FsName.S3, S3FsClient.create(s3Config));
        }
        if (enabledFs.contains((Object)FsName.GS)) {
            GsConfig gsConfig = config.gsConfig();
            if (gsConfig == null) {
                throw (IllegalArgumentException)log.entry("fs_client_composite_create_no_gs_config_failure").with("enabled_fs", enabledFs).exception(IllegalArgumentException::new);
            }
            clients.put(FsName.GS, GsFsClient.create(gsConfig));
        }
        if (enabledFs.contains((Object)FsName.ADLS2)) {
            Adls2Config adls2Config = config.adls2Config();
            if (adls2Config == null) {
                throw (IllegalArgumentException)log.entry("fs_client_composite_create_no_adls2_config_failure").with("enabled_fs", enabledFs).exception(IllegalArgumentException::new);
            }
            clients.put(FsName.ADLS2, Adls2FsClient.create(adls2Config));
        }
        return new CompositeFsClient(clients);
    }

    @Override
    public Stream<FsPath> listFiles(TracingContext ctx, FsUrl url) {
        FsClient client = this.fsClient(ctx, url);
        return client.listFiles(ctx, url);
    }

    @Override
    public InputStream inputStream(TracingContext ctx, FsUrl url) {
        FsClient client = this.fsClient(ctx, url);
        return client.inputStream(ctx, url);
    }

    @NotNull
    private FsClient fsClient(TracingContext ctx, FsUrl url) {
        FsClient client = this.clientMap.get((Object)url.fsName());
        if (client == null) {
            throw (IllegalArgumentException)log.entry("fs_client_composite_no_client_for_fsname_failure").context(ctx).with("fs_name", (Object)url.fsName()).with("url", (Object)url).exception(IllegalArgumentException::new);
        }
        return client;
    }

    @Override
    public void close() {
        for (Map.Entry<FsName, FsClient> entry : this.clientMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (RuntimeException e) {
                log.entry("fs_client_composite_close_client_failure").with("fs_name", (Object)entry.getKey()).error((Throwable)e);
            }
        }
    }
}

