/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.fsclient.Adls2Config;
import zeenea.connector.commons.fsclient.Adls2FsUrl;
import zeenea.connector.commons.fsclient.FsClient;
import zeenea.connector.commons.fsclient.FsClientException;
import zeenea.connector.commons.fsclient.FsPath;
import zeenea.connector.commons.fsclient.FsUrl;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;

public final class Adls2FsClient
extends FsClient {
    private static final SimpleLogger log = SimpleLogger.of(Adls2FsClient.class);
    private final Map<String, DataLakeServiceClient> clientMap = new HashMap<String, DataLakeServiceClient>();
    @NotNull
    private final Adls2Config config;

    private Adls2FsClient(@NotNull Adls2Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public static Adls2FsClient create(@NotNull Adls2Config config) {
        return new Adls2FsClient(config);
    }

    @Override
    public void close() {
    }

    @Override
    public Stream<FsPath> listFiles(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_adls2_list_files").context(ctx).with("url", (Object)url).debug();
        Adls2FsUrl azUrl = Adls2FsClient.checkUrl(ctx, url);
        DataLakeServiceClient client = this.client(ctx, azUrl);
        FsPath prefix = azUrl.path();
        return client.getFileSystemClient(azUrl.container()).listPaths(new ListPathsOptions().setPath(prefix.toString()).setRecursive(true), null).stream().map(item -> prefix.relativize(FsPath.of(item.getName())));
    }

    @Override
    public InputStream inputStream(TracingContext ctx, FsUrl url) {
        log.entry("fs_client_adls2_input_stream").context(ctx).with("url", (Object)url).debug();
        Adls2FsUrl azUrl = Adls2FsClient.checkUrl(ctx, url);
        DataLakeServiceClient client = this.client(ctx, azUrl);
        DataLakeFileClient fileClient = client.getFileSystemClient(azUrl.container()).getFileClient(azUrl.path().toString());
        if (!fileClient.exists().booleanValue()) {
            return null;
        }
        return fileClient.openInputStream().getInputStream();
    }

    private DataLakeServiceClient client(TracingContext ctx, Adls2FsUrl url) {
        String host = url.host();
        return this.clientMap.computeIfAbsent(host, k -> {
            HttpClient httpClient;
            DataLakeServiceClientBuilder builder = new DataLakeServiceClientBuilder().endpoint("https://" + host);
            HttpClientOptions httpOptions = this.httpClientOptions(ctx);
            if (httpOptions != null) {
                httpClient = HttpClient.createDefault((HttpClientOptions)httpOptions);
                builder.httpClient(httpClient);
            } else {
                httpClient = null;
            }
            this.addCredential(ctx, builder, httpClient);
            return builder.buildClient();
        });
    }

    private HttpClientOptions httpClientOptions(TracingContext ctx) {
        Proxy proxy = this.config.proxy();
        if (proxy == null) {
            return null;
        }
        try {
            int port = proxy.getPort();
            ProxyOptions.Type scheme = Optional.ofNullable(proxy.getScheme()).map(s -> ProxyOptions.Type.valueOf((String)s.toUpperCase(Locale.ROOT))).orElse(ProxyOptions.Type.HTTP);
            InetAddress inetAddr = InetAddress.getByName(proxy.getHostname());
            InetSocketAddress pAddress = new InetSocketAddress(inetAddr, port);
            ProxyOptions proxyOptions = new ProxyOptions(scheme, pAddress);
            String proxyUser = proxy.getUsername();
            String proxyPass = proxy.getPassword();
            if (proxyUser != null && proxyPass != null) {
                proxyOptions.setCredentials(proxyUser, proxyPass);
            }
            return new HttpClientOptions().setProxyOptions(proxyOptions);
        }
        catch (UnknownHostException e) {
            throw (FsClientException)log.entry("fs_client_adls2_client_proxy_unknown_host").context(ctx).exception((Throwable)e, FsClientException::new);
        }
    }

    private void addCredential(TracingContext ctx, @NotNull DataLakeServiceClientBuilder builder, @Nullable HttpClient httpClient) {
        String tenantId = this.config.tenantId();
        String clientId = this.config.clientId();
        String clientSecret = this.config.clientSecret();
        if (tenantId != null && clientId != null && clientSecret != null) {
            ClientSecretCredentialBuilder credBuilder = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret);
            if (httpClient != null) {
                credBuilder.httpClient(httpClient);
            }
            builder.credential((TokenCredential)credBuilder.build());
        } else {
            String accountName = this.config.accountName();
            String accountKey = this.config.accountKey();
            if (accountName != null && accountKey != null) {
                builder.credential(new StorageSharedKeyCredential(accountName, accountKey));
            } else {
                throw (FsClientException)log.entry("fs_client_adls2_no_credentials").context(ctx).exception(FsClientException::new);
            }
        }
    }

    private static Adls2FsUrl checkUrl(TracingContext ctx, FsUrl url) {
        if (!(url instanceof Adls2FsUrl)) {
            throw (IllegalArgumentException)log.entry("fs_client_adls2_unsupported_url").context(ctx).with("url", (Object)url).with("class", (Object)url.getClass().getName()).exception(IllegalArgumentException::new);
        }
        return (Adls2FsUrl)url;
    }
}

