/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.fsclient;

import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.configuration.AzureConfiguration;
import zeenea.connector.commons.fsclient.ImmutableAdls2Config;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceStringProperty;

@ImmutablePojo
public abstract class Adls2Config {
    private static final SimpleLogger log = SimpleLogger.of(Adls2Config.class);

    @Nullable
    public abstract String tenantId();

    @Nullable
    public abstract String clientId();

    @Nullable
    public abstract String clientSecret();

    @Nullable
    public abstract String accountName();

    @Nullable
    public abstract String accountKey();

    @Nullable
    public abstract Proxy proxy();

    public static Adls2Config parse(TracingContext ctx, PropertyValueMap configuration) {
        log.entry("fs_client_adls2_config_parse").context(ctx).debug();
        return ImmutableAdls2Config.builder().tenantId(configuration.get((SourceStringProperty)AzureConfiguration.AZURE_TENANT_ID).orElse(null)).clientId(configuration.get((SourceStringProperty)AzureConfiguration.AZURE_CLIENT_ID).orElse(null)).clientSecret(configuration.get((SourceStringProperty)AzureConfiguration.AZURE_CLIENT_SECRET).orElse(null)).accountName(configuration.get((SourceStringProperty)AzureConfiguration.AZURE_ACCOUNT_NAME).orElse(null)).accountKey(configuration.get((SourceStringProperty)AzureConfiguration.AZURE_ACCOUNT_KEY).orElse(null)).build();
    }
}

