/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.log;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import zeenea.connector.commons.log.Durations;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.StringUtil;

public class SimpleLogger {
    private static final Map<Class<?>, SimpleLogger> instances = new ConcurrentHashMap();
    private final Logger log;

    private SimpleLogger(Class<?> klass) {
        this.log = LoggerFactory.getLogger(klass);
    }

    public static SimpleLogger of(Class<?> klass) {
        return instances.computeIfAbsent(klass, SimpleLogger::new);
    }

    public Entry entry(String code) {
        return new Entry(code);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    private static final class EntryValue {
        private final String name;
        private final Supplier<?> valueSupplier;

        public EntryValue(String name, Supplier<?> valueSupplier) {
            this.name = name;
            this.valueSupplier = Objects.requireNonNull(valueSupplier);
        }

        String name() {
            return this.name;
        }

        private String value() {
            try {
                Object value = this.valueSupplier.get();
                return value != null ? value.toString() : "";
            }
            catch (RuntimeException e) {
                return "Failed to read value: " + e.getMessage();
            }
        }
    }

    public class Entry {
        private final String code;
        private final List<EntryValue> values = new ArrayList<EntryValue>();
        private Supplier<?> body;
        private List<EntryValue> namedBodies;
        private TracingContext context;
        private Instant startTime;
        private Instant endTime;
        private long startTimeNanos = -1L;
        private long endTimeNanos = -1L;
        private Verbosity verbosity = Verbosity.NORMAL;

        private Entry(String code) {
            this.code = code;
        }

        public Entry more(Consumer<Entry> adder) {
            adder.accept(this);
            return this;
        }

        public Entry with(String name, Object value) {
            this.values.add(new EntryValue(name, () -> value));
            return this;
        }

        public Entry with(String name, Supplier<?> value) {
            this.values.add(new EntryValue(name, value));
            return this;
        }

        public Entry body(Object body) {
            return this.body(() -> body);
        }

        public Entry body(Supplier<?> body) {
            this.body = body;
            return this;
        }

        public Entry body(String name, Object body) {
            return this.body(name, () -> body);
        }

        public Entry body(String name, Supplier<?> body) {
            if (this.namedBodies == null) {
                this.namedBodies = new ArrayList<EntryValue>();
            }
            this.namedBodies.add(new EntryValue(name, body));
            return this;
        }

        public Entry context(TracingContext ctx) {
            this.context = ctx;
            return this;
        }

        public Entry startTime(Instant startTime) {
            this.startTime = startTime;
            if (this.endTime == null) {
                this.endTime = Instant.now();
            }
            return this;
        }

        public Entry endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public Entry startTimeNanos(long startTime) {
            this.startTimeNanos = startTime;
            if (this.endTimeNanos < 0L) {
                this.endTimeNanos = System.nanoTime();
            }
            return this;
        }

        public Entry endTimeNanos(long endTime) {
            this.endTimeNanos = endTime;
            return this;
        }

        public Entry verbosity(Verbosity verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public Entry verbose() {
            return this.verbosity(Verbosity.NORMAL);
        }

        public Entry quiet() {
            return this.verbosity(Verbosity.QUIET);
        }

        public Entry veryQuiet() {
            return this.verbosity(Verbosity.VERY_QUIET);
        }

        public void error() {
            this.log(Level.ERROR);
        }

        public void error(Throwable cause) {
            this.log(Level.ERROR, cause);
        }

        public void warn() {
            this.log(Level.WARN);
        }

        public void warn(Throwable cause) {
            this.log(Level.WARN, cause);
        }

        public void info() {
            this.log(Level.INFO);
        }

        public void info(Throwable cause) {
            this.log(Level.INFO, cause);
        }

        public void debug() {
            this.log(Level.DEBUG);
        }

        public void debug(Throwable cause) {
            this.log(Level.DEBUG, cause);
        }

        public void trace() {
            this.log(Level.TRACE);
        }

        public void trace(Throwable cause) {
            this.log(Level.TRACE, cause);
        }

        public <T extends Throwable> T exception(Function<String, T> ex) {
            StringBuilder msgBuilder = this.commonMessage();
            this.addBodyMessage(msgBuilder);
            String msg = msgBuilder.toString();
            SimpleLogger.this.log.debug(msg);
            return (T)((Throwable)ex.apply(msg));
        }

        public <T extends Throwable, U extends Throwable> T exception(U cause, BiFunction<String, U, T> ex) {
            StringBuilder msgBuilder = this.commonMessage();
            this.addBodyMessage(msgBuilder);
            String msg = msgBuilder.toString();
            SimpleLogger.this.log.debug(msg, cause);
            return (T)((Throwable)ex.apply(msg, cause));
        }

        private void log(Level level) {
            if (this.isEnabled(level)) {
                StringBuilder msgBuilder = this.commonMessage();
                this.addBodyMessage(msgBuilder);
                this.writeLog(level, msgBuilder.toString());
            }
        }

        private void log(Level level, Throwable cause) {
            if (this.isEnabled(level)) {
                StringBuilder msgBuilder = this.commonMessage();
                this.addBodyMessage(msgBuilder);
                if (this.verbosity == Verbosity.NORMAL || this.verbosity == Verbosity.QUIET && SimpleLogger.this.log.isDebugEnabled() || SimpleLogger.this.log.isTraceEnabled()) {
                    this.writeLog(level, msgBuilder.toString(), cause);
                } else {
                    this.addCauseMessage(msgBuilder, cause);
                    this.writeLog(level, msgBuilder.toString());
                }
            }
        }

        private StringBuilder commonMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.code);
            if (this.context == null) {
                this.context = TracingContext.current();
            }
            if (this.context != null) {
                sb.append(' ').append(this.context);
            }
            if (this.startTime != null) {
                sb.append(" duration='");
                Durations.appendTo(sb, this.startTime, this.endTime);
                sb.append('\'');
            } else if (this.startTimeNanos >= 0L) {
                sb.append(" duration='");
                Durations.appendTo(sb, Duration.ofNanos(this.endTimeNanos - this.startTimeNanos));
                sb.append('\'');
            }
            for (EntryValue value : this.values) {
                sb.append(' ');
                sb.append(value.name());
                sb.append("='");
                sb.append(value.value().replace("'", "''"));
                sb.append('\'');
            }
            return sb;
        }

        private void addBodyMessage(StringBuilder msgBuilder) {
            Object bodyVal;
            Object object = bodyVal = this.body != null ? (Object)this.body.get() : null;
            if (bodyVal != null) {
                msgBuilder.append(System.lineSeparator());
                msgBuilder.append("    ");
                msgBuilder.append("-".repeat(72));
                msgBuilder.append(System.lineSeparator());
                msgBuilder.append(StringUtil.indent(bodyVal.toString(), 4));
            }
            if (this.namedBodies != null) {
                for (EntryValue namedBody : this.namedBodies) {
                    int rightLineLen;
                    int leftLineLen;
                    String name = namedBody.name();
                    int nameLen = name.length();
                    if (nameLen < 62) {
                        leftLineLen = (70 - nameLen) / 2;
                        rightLineLen = 70 - nameLen - leftLineLen;
                    } else {
                        rightLineLen = 4;
                        leftLineLen = 4;
                    }
                    msgBuilder.append(System.lineSeparator());
                    msgBuilder.append(StringUtil.indent("-".repeat(leftLineLen), 4));
                    msgBuilder.append(' ');
                    msgBuilder.append(name);
                    msgBuilder.append(' ');
                    msgBuilder.append("-".repeat(rightLineLen));
                    msgBuilder.append(System.lineSeparator());
                    msgBuilder.append(StringUtil.indent(namedBody.value(), 4));
                }
            }
            if (bodyVal != null || this.namedBodies != null && !this.namedBodies.isEmpty()) {
                msgBuilder.append(System.lineSeparator());
                msgBuilder.append("    ");
                msgBuilder.append("-".repeat(72));
            }
        }

        private void addCauseMessage(StringBuilder msgBuilder, Throwable cause) {
            for (Throwable c = cause; c != null; c = c.getCause()) {
                msgBuilder.append(System.lineSeparator()).append(StringUtil.indent("Cause: " + c.getMessage(), 4));
            }
        }

        private boolean isEnabled(Level level) {
            switch (level) {
                case ERROR: {
                    return SimpleLogger.this.log.isErrorEnabled();
                }
                case WARN: {
                    return SimpleLogger.this.log.isWarnEnabled();
                }
                case INFO: {
                    return SimpleLogger.this.log.isInfoEnabled();
                }
                case DEBUG: {
                    return SimpleLogger.this.log.isDebugEnabled();
                }
                case TRACE: {
                    return SimpleLogger.this.log.isTraceEnabled();
                }
            }
            SimpleLogger.this.log.error("Unknown log level: " + String.valueOf(level));
            return false;
        }

        private void writeLog(Level level, String message) {
            switch (level) {
                case ERROR: {
                    SimpleLogger.this.log.error(message);
                    break;
                }
                case WARN: {
                    SimpleLogger.this.log.warn(message);
                    break;
                }
                case INFO: {
                    SimpleLogger.this.log.info(message);
                    break;
                }
                case DEBUG: {
                    SimpleLogger.this.log.debug(message);
                    break;
                }
                case TRACE: {
                    SimpleLogger.this.log.trace(message);
                    break;
                }
                default: {
                    SimpleLogger.this.log.error("Unknown log level: " + String.valueOf(level));
                }
            }
        }

        private void writeLog(Level level, String message, Throwable cause) {
            switch (level) {
                case ERROR: {
                    SimpleLogger.this.log.error(message, cause);
                    break;
                }
                case WARN: {
                    SimpleLogger.this.log.warn(message, cause);
                    break;
                }
                case INFO: {
                    SimpleLogger.this.log.info(message, cause);
                    break;
                }
                case DEBUG: {
                    SimpleLogger.this.log.debug(message, cause);
                    break;
                }
                case TRACE: {
                    SimpleLogger.this.log.trace(message, cause);
                    break;
                }
                default: {
                    SimpleLogger.this.log.error("Unknown log level: " + String.valueOf(level));
                }
            }
        }
    }

    public static enum Verbosity {
        NORMAL,
        QUIET,
        VERY_QUIET;

    }
}

