/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.sql.parser;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.sql.parser.ImmutableSqlStatement;
import zeenea.connector.commons.sql.parser.SqlParserException;
import zeenea.connector.commons.sql.parser.SqlStatement;
import zeenea.connector.commons.sql.parser.SqlTable;
import zeenea.connector.commons.sql.parser.TableFinder;

public final class SqlParser {
    private static final SimpleLogger log = SimpleLogger.of(SqlParser.class);
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    @NotNull
    private final DbEngine engine;

    public SqlParser(@NotNull DbEngine engine) {
        this.engine = Objects.requireNonNull(engine);
    }

    public static SqlParser of(@NotNull DbEngine engine) {
        return new SqlParser(engine);
    }

    public List<SqlStatement> parse(@Nullable TracingContext ctx, Path path, Charset charset) {
        List<SqlStatement> list;
        block9: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                list = this.parse(ctx, is, charset);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SqlParserException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (SqlParserException)log.entry("sql_parse_from_path_failed").context(ctx).with("path", (Object)path).with("charset", (Object)charset).exception((Throwable)e, SqlParserException::new);
                }
            }
            is.close();
        }
        return list;
    }

    public List<SqlStatement> parse(@Nullable TracingContext ctx, InputStream is, Charset charset) {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((InputStream)is, (String)charset.name());
            return this.doParse(ctx, parser, null);
        }
        catch (Exception e) {
            throw (SqlParserException)log.entry("sql_parse_from_input_stream_failed").context(ctx).with("charset", (Object)charset).exception((Throwable)e, SqlParserException::new);
        }
    }

    public List<SqlStatement> parse(@Nullable TracingContext ctx, String statement) {
        String sanitized = SqlParser.sanitize(statement);
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((String)sanitized);
            return this.doParse(ctx, parser, sanitized);
        }
        catch (Exception e) {
            throw (SqlParserException)log.entry("sql_parse_from_string_failed").context(ctx).with("statement", (Object)statement).with("sanitized", (Object)sanitized).exception((Throwable)e, SqlParserException::new);
        }
    }

    public SqlStatement parseFirst(@Nullable TracingContext ctx, String statement) {
        List<SqlStatement> statements = this.parse(ctx, statement);
        if (statements.isEmpty()) {
            throw (SqlParserException)log.entry("no_sql_statement_found").context(ctx).exception(SqlParserException::new);
        }
        return statements.get(0);
    }

    public SqlStatement parseExpression(@Nullable TracingContext ctx, String statement) {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser((String)statement);
            this.prepareParser(parser);
            Column expression = (Column)parser.Expression();
            ArrayList<String> nameParts = new ArrayList<String>();
            nameParts.add(expression.getColumnName());
            Table expressionTable = expression.getTable();
            if (expressionTable != null) {
                nameParts.addAll(expression.getTable().getNameParts());
            }
            SqlTable table = this.toSqlTable(ctx, nameParts);
            ImmutableSqlStatement element = ImmutableSqlStatement.builder().statement(statement).sourceTables(List.of(table)).build();
            log.entry("sql_parse_expression_from_string").context(ctx).with("element", (Object)element).debug();
            return element;
        }
        catch (Exception e) {
            throw (SqlParserException)log.entry("sql_parse_expression_from_string_failed").context(ctx).with("statement", (Object)statement).exception((Throwable)e, SqlParserException::new);
        }
    }

    private void prepareParser(@NotNull CCJSqlParser parser) {
        parser.withSquareBracketQuotation(true);
        parser.withAllowComplexParsing(true);
    }

    private List<SqlStatement> doParse(@Nullable TracingContext ctx, @NotNull CCJSqlParser parser, @Nullable String sql) throws JSQLParserException {
        this.prepareParser(parser);
        return CCJSqlParserUtil.parseStatements((CCJSqlParser)parser, (ExecutorService)Executors.newSingleThreadExecutor()).stream().map(stmt -> this.toSqlStatement(ctx, (Statement)stmt, sql)).collect(Collectors.toList());
    }

    private SqlStatement toSqlStatement(@Nullable TracingContext ctx, Statement stmt, @Nullable String sql) {
        TableFinder tableFinder = new TableFinder();
        ArrayList<String> foundTables = new ArrayList<String>(tableFinder.getTables(stmt));
        List sources = tableFinder.getSources(foundTables).stream().map(table -> this.toSqlTable(ctx, table.getNameParts())).filter(Objects::nonNull).collect(Collectors.toList());
        List targets = tableFinder.getTargets(foundTables).stream().map(table -> this.toSqlTable(ctx, table.getNameParts())).filter(Objects::nonNull).collect(Collectors.toList());
        ImmutableSqlStatement statement = ImmutableSqlStatement.builder().statement(sql).sourceTables(sources).targetTables(targets).build();
        if (statement.statement() != null) {
            log.entry("sql_parser_statement").context(ctx).with("statement", (Object)statement.statement()).debug();
        }
        log.entry("sql_parser_extracted_tables").context(ctx).with("source_tables", statement.sourceTables()).with("target_tables", statement.targetTables()).debug();
        return statement;
    }

    @Nullable
    private SqlTable toSqlTable(@Nullable TracingContext ctx, @NotNull List<String> nameParts) {
        String database;
        if (nameParts.isEmpty()) {
            log.entry("sql_parser_empty_element_list").context(ctx).with("name_parts", nameParts).error();
            return null;
        }
        String table = this.unescape(nameParts.get(0));
        String schema = nameParts.size() > 1 ? this.unescape(nameParts.get(1)) : null;
        String string = database = nameParts.size() > 2 ? this.unescape(nameParts.get(2)) : null;
        if (this.engine == DbEngine.BIGQUERY) {
            List identifiers = Stream.of(database, schema, table).filter(Objects::nonNull).flatMap(DOT_PATTERN::splitAsStream).collect(Collectors.toUnmodifiableList());
            int n = identifiers.size();
            if (n == 0) {
                log.entry("sql_parser_empty_bigquery_table_identifier").with("name_parts", nameParts).with("identifiers", identifiers).warn();
                return null;
            }
            if (n > 3) {
                log.entry("sql_parser_invalid_bigquery_table_identifier").with("name_parts", nameParts).with("identifiers", identifiers).warn();
            }
            table = (String)identifiers.get(n - 1);
            schema = n >= 2 ? (String)identifiers.get(n - 2) : null;
            String string2 = database = n >= 3 ? (String)identifiers.get(n - 3) : null;
        }
        if (table == null) {
            log.entry("sql_parser_no_table_name").context(ctx).with("name_parts", nameParts).with("database", (Object)database).with("schema", (Object)schema).warn();
            return null;
        }
        log.entry("sql_parser_table_found").context(ctx).with("name_parts", nameParts).with("database", (Object)database).with("schema", (Object)schema).with("table", (Object)table).debug();
        return SqlTable.of(this.engine, database, schema, table);
    }

    @Nullable
    private String unescape(@Nullable String identifier) {
        try {
            return this.engine.unescape(identifier);
        }
        catch (IllegalArgumentException e) {
            throw (SqlParserException)log.entry("sql_parser_invalid_identifier").with("identifier", (Object)identifier).exception((Throwable)e, SqlParserException::new);
        }
    }

    public static String sanitize(@Nullable String statement) {
        return statement == null ? null : statement.replaceAll("(?m)^[ \t]*\r?\n", "").replaceAll("(?i)(?<=SELECT )(.*?)(?= FROM )", "*");
    }
}

