/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.sql.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.db.DbEngine;
import zeenea.connector.commons.sql.parser.SqlTable;

@ParametersAreNonnullByDefault
@Generated(from="SqlTable", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSqlTable
implements SqlTable {
    @NotNull
    private final DbEngine engine;
    @NotNull
    private final String table;
    @Nullable
    private final String schema;
    @Nullable
    private final String database;

    private ImmutableSqlTable(DbEngine engine, String table, @Nullable String schema, @Nullable String database) {
        this.engine = engine;
        this.table = table;
        this.schema = schema;
        this.database = database;
    }

    @Override
    @NotNull
    public DbEngine engine() {
        return this.engine;
    }

    @Override
    @NotNull
    public String table() {
        return this.table;
    }

    @Override
    @Nullable
    public String schema() {
        return this.schema;
    }

    @Override
    @Nullable
    public String database() {
        return this.database;
    }

    public final ImmutableSqlTable withEngine(DbEngine value) {
        DbEngine newValue = Objects.requireNonNull(value, "engine");
        if (this.engine == newValue) {
            return this;
        }
        return new ImmutableSqlTable(newValue, this.table, this.schema, this.database);
    }

    public final ImmutableSqlTable withTable(String value) {
        String newValue = Objects.requireNonNull(value, "table");
        if (this.table.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlTable(this.engine, newValue, this.schema, this.database);
    }

    public final ImmutableSqlTable withSchema(@Nullable String value) {
        if (Objects.equals(this.schema, value)) {
            return this;
        }
        return new ImmutableSqlTable(this.engine, this.table, value, this.database);
    }

    public final ImmutableSqlTable withDatabase(@Nullable String value) {
        if (Objects.equals(this.database, value)) {
            return this;
        }
        return new ImmutableSqlTable(this.engine, this.table, this.schema, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlTable && this.equalTo(0, (ImmutableSqlTable)another);
    }

    private boolean equalTo(int synthetic, ImmutableSqlTable another) {
        return this.engine.equals((Object)another.engine) && this.table.equals(another.table) && Objects.equals(this.schema, another.schema) && Objects.equals(this.database, another.database);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.engine.hashCode();
        h += (h << 5) + this.table.hashCode();
        h += (h << 5) + Objects.hashCode(this.schema);
        h += (h << 5) + Objects.hashCode(this.database);
        return h;
    }

    public String toString() {
        return "SqlTable{engine=" + String.valueOf(this.engine) + ", table=" + this.table + ", schema=" + this.schema + ", database=" + this.database + "}";
    }

    public static ImmutableSqlTable copyOf(SqlTable instance) {
        if (instance instanceof ImmutableSqlTable) {
            return (ImmutableSqlTable)instance;
        }
        return ImmutableSqlTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENGINE = 1L;
        private static final long INIT_BIT_TABLE = 2L;
        private long initBits = 3L;
        @javax.annotation.Nullable
        private DbEngine engine;
        @javax.annotation.Nullable
        private String table;
        @javax.annotation.Nullable
        private String schema;
        @javax.annotation.Nullable
        private String database;

        private Builder() {
        }

        public final Builder from(SqlTable instance) {
            String databaseValue;
            Objects.requireNonNull(instance, "instance");
            this.engine(instance.engine());
            this.table(instance.table());
            @Nullable String schemaValue = instance.schema();
            if (schemaValue != null) {
                this.schema(schemaValue);
            }
            if ((databaseValue = instance.database()) != null) {
                this.database(databaseValue);
            }
            return this;
        }

        public final Builder engine(DbEngine engine) {
            this.engine = Objects.requireNonNull(engine, "engine");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder table(String table) {
            this.table = Objects.requireNonNull(table, "table");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder schema(@Nullable String schema) {
            this.schema = schema;
            return this;
        }

        public final Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public ImmutableSqlTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlTable(this.engine, this.table, this.schema, this.database);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("engine");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("table");
            }
            return "Cannot build SqlTable, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

