package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Space}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpace.builder()}.
 */
@Generated(from = "Space", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSpace implements Space {
  private final String name;

  private ImmutableSpace(String name) {
    this.name = name;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Space#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpace withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableSpace(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpace} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpace
        && equalTo(0, (ImmutableSpace) another);
  }

  private boolean equalTo(int synthetic, ImmutableSpace another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Space} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Space{"
        + "name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Space", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Space {
    String name;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSpace fromJson(Json json) {
    ImmutableSpace.Builder builder = ImmutableSpace.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Space} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Space instance
   */
  public static ImmutableSpace copyOf(Space instance) {
    if (instance instanceof ImmutableSpace) {
      return (ImmutableSpace) instance;
    }
    return ImmutableSpace.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpace ImmutableSpace}.
   * <pre>
   * ImmutableSpace.builder()
   *    .name(String) // required {@link Space#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableSpace builder
   */
  public static ImmutableSpace.Builder builder() {
    return new ImmutableSpace.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpace ImmutableSpace}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Space", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Space} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Space instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link Space#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpace ImmutableSpace}.
     * @return An immutable instance of Space
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSpace build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSpace(name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Space, some of required attributes are not set " + attributes;
    }
  }
}
