package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ResultMaker}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResultMaker.builder()}.
 */
@Generated(from = "ResultMaker", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableResultMaker implements ResultMaker {
  private final @Nullable Query query;

  private ImmutableResultMaker(@Nullable Query query) {
    this.query = query;
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @JsonProperty("query")
  @Override
  public @Nullable Query getQuery() {
    return query;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResultMaker#getQuery() query} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for query (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResultMaker withQuery(@Nullable Query value) {
    if (this.query == value) return this;
    return new ImmutableResultMaker(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResultMaker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResultMaker
        && equalTo(0, (ImmutableResultMaker) another);
  }

  private boolean equalTo(int synthetic, ImmutableResultMaker another) {
    return Objects.equals(query, another.query);
  }

  /**
   * Computes a hash code from attributes: {@code query}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(query);
    return h;
  }

  /**
   * Prints the immutable value {@code ResultMaker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ResultMaker{"
        + "query=" + query
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ResultMaker", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ResultMaker {
    Query query;
    @JsonProperty("query")
    public void setQuery(@Nullable Query query) {
      this.query = query;
    }
    @Override
    public Query getQuery() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableResultMaker fromJson(Json json) {
    ImmutableResultMaker.Builder builder = ImmutableResultMaker.builder();
    if (json.query != null) {
      builder.query(json.query);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ResultMaker} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ResultMaker instance
   */
  public static ImmutableResultMaker copyOf(ResultMaker instance) {
    if (instance instanceof ImmutableResultMaker) {
      return (ImmutableResultMaker) instance;
    }
    return ImmutableResultMaker.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResultMaker ImmutableResultMaker}.
   * <pre>
   * ImmutableResultMaker.builder()
   *    .query(zeenea.connector.looker.client.model.Query | null) // nullable {@link ResultMaker#getQuery() query}
   *    .build();
   * </pre>
   * @return A new ImmutableResultMaker builder
   */
  public static ImmutableResultMaker.Builder builder() {
    return new ImmutableResultMaker.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResultMaker ImmutableResultMaker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ResultMaker", generator = "Immutables")
  public static final class Builder {
    private Query query;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ResultMaker} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResultMaker instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Query queryValue = instance.getQuery();
      if (queryValue != null) {
        query(queryValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ResultMaker#getQuery() query} attribute.
     * @param query The value for query (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("query")
    public final Builder query(@Nullable Query query) {
      this.query = query;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResultMaker ImmutableResultMaker}.
     * @return An immutable instance of ResultMaker
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResultMaker build() {
      return new ImmutableResultMaker(query);
    }
  }
}
