package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Query}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuery.builder()}.
 */
@Generated(from = "Query", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQuery implements Query {
  private final @Nullable String model;
  private final @Nullable String view;

  private ImmutableQuery(
      @Nullable String model,
      @Nullable String view) {
    this.model = model;
    this.view = view;
  }

  /**
   * @return The value of the {@code model} attribute
   */
  @JsonProperty("model")
  @Override
  public @Nullable String getModel() {
    return model;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty("view")
  @Override
  public @Nullable String getView() {
    return view;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Query#getModel() model} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for model (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuery withModel(@Nullable String value) {
    if (Objects.equals(this.model, value)) return this;
    return new ImmutableQuery(value, this.view);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Query#getView() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuery withView(@Nullable String value) {
    if (Objects.equals(this.view, value)) return this;
    return new ImmutableQuery(this.model, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuery} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuery
        && equalTo(0, (ImmutableQuery) another);
  }

  private boolean equalTo(int synthetic, ImmutableQuery another) {
    return Objects.equals(model, another.model)
        && Objects.equals(view, another.view);
  }

  /**
   * Computes a hash code from attributes: {@code model}, {@code view}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(model);
    h += (h << 5) + Objects.hashCode(view);
    return h;
  }

  /**
   * Prints the immutable value {@code Query} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Query{"
        + "model=" + model
        + ", view=" + view
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Query", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Query {
    String model;
    String view;
    @JsonProperty("model")
    public void setModel(@Nullable String model) {
      this.model = model;
    }
    @JsonProperty("view")
    public void setView(@Nullable String view) {
      this.view = view;
    }
    @Override
    public String getModel() { throw new UnsupportedOperationException(); }
    @Override
    public String getView() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQuery fromJson(Json json) {
    ImmutableQuery.Builder builder = ImmutableQuery.builder();
    if (json.model != null) {
      builder.model(json.model);
    }
    if (json.view != null) {
      builder.view(json.view);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Query} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Query instance
   */
  public static ImmutableQuery copyOf(Query instance) {
    if (instance instanceof ImmutableQuery) {
      return (ImmutableQuery) instance;
    }
    return ImmutableQuery.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuery ImmutableQuery}.
   * <pre>
   * ImmutableQuery.builder()
   *    .model(String | null) // nullable {@link Query#getModel() model}
   *    .view(String | null) // nullable {@link Query#getView() view}
   *    .build();
   * </pre>
   * @return A new ImmutableQuery builder
   */
  public static ImmutableQuery.Builder builder() {
    return new ImmutableQuery.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuery ImmutableQuery}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Query", generator = "Immutables")
  public static final class Builder {
    private String model;
    private String view;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Query} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Query instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String modelValue = instance.getModel();
      if (modelValue != null) {
        model(modelValue);
      }
      @Nullable String viewValue = instance.getView();
      if (viewValue != null) {
        view(viewValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Query#getModel() model} attribute.
     * @param model The value for model (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("model")
    public final Builder model(@Nullable String model) {
      this.model = model;
      return this;
    }

    /**
     * Initializes the value for the {@link Query#getView() view} attribute.
     * @param view The value for view (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view")
    public final Builder view(@Nullable String view) {
      this.view = view;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuery ImmutableQuery}.
     * @return An immutable instance of Query
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuery build() {
      return new ImmutableQuery(model, view);
    }
  }
}
