package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Folder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFolder.builder()}.
 */
@Generated(from = "Folder", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFolder implements Folder {
  private final String name;
  private final String id;
  private final @Nullable Integer parentId;

  private ImmutableFolder(
      String name,
      String id,
      @Nullable Integer parentId) {
    this.name = name;
    this.id = id;
    this.parentId = parentId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @JsonProperty("parent_id")
  @Override
  public @Nullable Integer getParentId() {
    return parentId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Folder#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolder withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFolder(newValue, this.id, this.parentId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Folder#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolder withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableFolder(this.name, newValue, this.parentId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Folder#getParentId() parentId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFolder withParentId(@Nullable Integer value) {
    if (Objects.equals(this.parentId, value)) return this;
    return new ImmutableFolder(this.name, this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFolder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFolder
        && equalTo(0, (ImmutableFolder) another);
  }

  private boolean equalTo(int synthetic, ImmutableFolder another) {
    return name.equals(another.name)
        && id.equals(another.id)
        && Objects.equals(parentId, another.parentId);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code id}, {@code parentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(parentId);
    return h;
  }

  /**
   * Prints the immutable value {@code Folder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Folder{"
        + "name=" + name
        + ", id=" + id
        + ", parentId=" + parentId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Folder", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Folder {
    String name;
    String id;
    Integer parentId;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("parent_id")
    public void setParentId(@Nullable Integer parentId) {
      this.parentId = parentId;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getParentId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFolder fromJson(Json json) {
    ImmutableFolder.Builder builder = ImmutableFolder.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.parentId != null) {
      builder.parentId(json.parentId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Folder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Folder instance
   */
  public static ImmutableFolder copyOf(Folder instance) {
    if (instance instanceof ImmutableFolder) {
      return (ImmutableFolder) instance;
    }
    return ImmutableFolder.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFolder ImmutableFolder}.
   * <pre>
   * ImmutableFolder.builder()
   *    .name(String) // required {@link Folder#getName() name}
   *    .id(String) // required {@link Folder#getId() id}
   *    .parentId(Integer | null) // nullable {@link Folder#getParentId() parentId}
   *    .build();
   * </pre>
   * @return A new ImmutableFolder builder
   */
  public static ImmutableFolder.Builder builder() {
    return new ImmutableFolder.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFolder ImmutableFolder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Folder", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String id;
    private Integer parentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Folder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Folder instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.id(instance.getId());
      @Nullable Integer parentIdValue = instance.getParentId();
      if (parentIdValue != null) {
        parentId(parentIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Folder#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Folder#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Folder#getParentId() parentId} attribute.
     * @param parentId The value for parentId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent_id")
    public final Builder parentId(@Nullable Integer parentId) {
      this.parentId = parentId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFolder ImmutableFolder}.
     * @return An immutable instance of Folder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFolder build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFolder(name, id, parentId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Folder, some of required attributes are not set " + attributes;
    }
  }
}
