package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Fields}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFields.builder()}.
 */
@Generated(from = "Fields", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFields implements Fields {
  private final List<Field> dimensions;
  private final List<Field> measures;

  private ImmutableFields(
      List<Field> dimensions,
      List<Field> measures) {
    this.dimensions = dimensions;
    this.measures = measures;
  }

  /**
   * @return The value of the {@code dimensions} attribute
   */
  @JsonProperty("dimensions")
  @Override
  public List<Field> getDimensions() {
    return dimensions;
  }

  /**
   * @return The value of the {@code measures} attribute
   */
  @JsonProperty("measures")
  @Override
  public List<Field> getMeasures() {
    return measures;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fields#getDimensions() dimensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFields withDimensions(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableFields(newValue, this.measures);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fields#getDimensions() dimensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dimensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFields withDimensions(Iterable<? extends Field> elements) {
    if (this.dimensions == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableFields(newValue, this.measures);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fields#getMeasures() measures}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFields withMeasures(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableFields(this.dimensions, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fields#getMeasures() measures}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of measures elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFields withMeasures(Iterable<? extends Field> elements) {
    if (this.measures == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableFields(this.dimensions, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFields} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFields
        && equalTo(0, (ImmutableFields) another);
  }

  private boolean equalTo(int synthetic, ImmutableFields another) {
    return dimensions.equals(another.dimensions)
        && measures.equals(another.measures);
  }

  /**
   * Computes a hash code from attributes: {@code dimensions}, {@code measures}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + dimensions.hashCode();
    h += (h << 5) + measures.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Fields} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Fields{"
        + "dimensions=" + dimensions
        + ", measures=" + measures
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Fields", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Fields {
    List<Field> dimensions = List.of();
    List<Field> measures = List.of();
    @JsonProperty("dimensions")
    public void setDimensions(List<Field> dimensions) {
      this.dimensions = dimensions;
    }
    @JsonProperty("measures")
    public void setMeasures(List<Field> measures) {
      this.measures = measures;
    }
    @Override
    public List<Field> getDimensions() { throw new UnsupportedOperationException(); }
    @Override
    public List<Field> getMeasures() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFields fromJson(Json json) {
    ImmutableFields.Builder builder = ImmutableFields.builder();
    if (json.dimensions != null) {
      builder.addAllDimensions(json.dimensions);
    }
    if (json.measures != null) {
      builder.addAllMeasures(json.measures);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Fields} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Fields instance
   */
  public static ImmutableFields copyOf(Fields instance) {
    if (instance instanceof ImmutableFields) {
      return (ImmutableFields) instance;
    }
    return ImmutableFields.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFields ImmutableFields}.
   * <pre>
   * ImmutableFields.builder()
   *    .addDimensions|addAllDimensions(zeenea.connector.looker.client.model.Field) // {@link Fields#getDimensions() dimensions} elements
   *    .addMeasures|addAllMeasures(zeenea.connector.looker.client.model.Field) // {@link Fields#getMeasures() measures} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFields builder
   */
  public static ImmutableFields.Builder builder() {
    return new ImmutableFields.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFields ImmutableFields}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Fields", generator = "Immutables")
  public static final class Builder {
    private List<Field> dimensions = new ArrayList<Field>();
    private List<Field> measures = new ArrayList<Field>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Fields} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Fields instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDimensions(instance.getDimensions());
      addAllMeasures(instance.getMeasures());
      return this;
    }

    /**
     * Adds one element to {@link Fields#getDimensions() dimensions} list.
     * @param element A dimensions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Field element) {
      this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      return this;
    }

    /**
     * Adds elements to {@link Fields#getDimensions() dimensions} list.
     * @param elements An array of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Field... elements) {
      for (Field element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Fields#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dimensions")
    public final Builder dimensions(Iterable<? extends Field> elements) {
      this.dimensions.clear();
      return addAllDimensions(elements);
    }

    /**
     * Adds elements to {@link Fields#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDimensions(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Fields#getMeasures() measures} list.
     * @param element A measures element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasures(Field element) {
      this.measures.add(Objects.requireNonNull(element, "measures element"));
      return this;
    }

    /**
     * Adds elements to {@link Fields#getMeasures() measures} list.
     * @param elements An array of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasures(Field... elements) {
      for (Field element : elements) {
        this.measures.add(Objects.requireNonNull(element, "measures element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Fields#getMeasures() measures} list.
     * @param elements An iterable of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("measures")
    public final Builder measures(Iterable<? extends Field> elements) {
      this.measures.clear();
      return addAllMeasures(elements);
    }

    /**
     * Adds elements to {@link Fields#getMeasures() measures} list.
     * @param elements An iterable of measures elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMeasures(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.measures.add(Objects.requireNonNull(element, "measures element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFields ImmutableFields}.
     * @return An immutable instance of Fields
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFields build() {
      return new ImmutableFields(List.copyOf(dimensions), List.copyOf(measures));
    }
  }
}
