package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableField implements Field {
  private final String name;
  private final String label;
  private final String type;
  private final String primaryKey;
  private final String measure;

  private ImmutableField(
      String name,
      String label,
      String type,
      String primaryKey,
      String measure) {
    this.name = name;
    this.label = label;
    this.type = type;
    this.primaryKey = primaryKey;
    this.measure = measure;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code primaryKey} attribute
   */
  @JsonProperty("primary_key")
  @Override
  public String getPrimaryKey() {
    return primaryKey;
  }

  /**
   * @return The value of the {@code measure} attribute
   */
  @JsonProperty("measure")
  @Override
  public String getMeasure() {
    return measure;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(newValue, this.label, this.type, this.primaryKey, this.measure);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableField(this.name, newValue, this.type, this.primaryKey, this.measure);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableField(this.name, this.label, newValue, this.primaryKey, this.measure);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getPrimaryKey() primaryKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primaryKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withPrimaryKey(String value) {
    String newValue = Objects.requireNonNull(value, "primaryKey");
    if (this.primaryKey.equals(newValue)) return this;
    return new ImmutableField(this.name, this.label, this.type, newValue, this.measure);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#getMeasure() measure} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for measure
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withMeasure(String value) {
    String newValue = Objects.requireNonNull(value, "measure");
    if (this.measure.equals(newValue)) return this;
    return new ImmutableField(this.name, this.label, this.type, this.primaryKey, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && label.equals(another.label)
        && type.equals(another.type)
        && primaryKey.equals(another.primaryKey)
        && measure.equals(another.measure);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code label}, {@code type}, {@code primaryKey}, {@code measure}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + primaryKey.hashCode();
    h += (h << 5) + measure.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", label=" + label
        + ", type=" + type
        + ", primaryKey=" + primaryKey
        + ", measure=" + measure
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Field", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Field {
    String name;
    String label;
    String type;
    String primaryKey;
    String measure;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("label")
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("primary_key")
    public void setPrimaryKey(String primaryKey) {
      this.primaryKey = primaryKey;
    }
    @JsonProperty("measure")
    public void setMeasure(String measure) {
      this.measure = measure;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrimaryKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getMeasure() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableField fromJson(Json json) {
    ImmutableField.Builder builder = ImmutableField.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.primaryKey != null) {
      builder.primaryKey(json.primaryKey);
    }
    if (json.measure != null) {
      builder.measure(json.measure);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#getName() name}
   *    .label(String) // required {@link Field#getLabel() label}
   *    .type(String) // required {@link Field#getType() type}
   *    .primaryKey(String) // required {@link Field#getPrimaryKey() primaryKey}
   *    .measure(String) // required {@link Field#getMeasure() measure}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_PRIMARY_KEY = 0x8L;
    private static final long INIT_BIT_MEASURE = 0x10L;
    private long initBits = 0x1fL;

    private String name;
    private String label;
    private String type;
    private String primaryKey;
    private String measure;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.label(instance.getLabel());
      this.type(instance.getType());
      this.primaryKey(instance.getPrimaryKey());
      this.measure(instance.getMeasure());
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getPrimaryKey() primaryKey} attribute.
     * @param primaryKey The value for primaryKey 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("primary_key")
    public final Builder primaryKey(String primaryKey) {
      this.primaryKey = Objects.requireNonNull(primaryKey, "primaryKey");
      initBits &= ~INIT_BIT_PRIMARY_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#getMeasure() measure} attribute.
     * @param measure The value for measure 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("measure")
    public final Builder measure(String measure) {
      this.measure = Objects.requireNonNull(measure, "measure");
      initBits &= ~INIT_BIT_MEASURE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(name, label, type, primaryKey, measure);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_PRIMARY_KEY) != 0) attributes.add("primaryKey");
      if ((initBits & INIT_BIT_MEASURE) != 0) attributes.add("measure");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
