package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExploreDetail}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExploreDetail.builder()}.
 */
@Generated(from = "ExploreDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableExploreDetail implements ExploreDetail {
  private final String id;
  private final String name;
  private final String label;
  private final String connectionName;
  private final Fields fields;
  private final List<String> scopes;
  private final String modelName;
  private final String sqlTableName;

  private ImmutableExploreDetail(
      String id,
      String name,
      String label,
      String connectionName,
      Fields fields,
      List<String> scopes,
      String modelName,
      String sqlTableName) {
    this.id = id;
    this.name = name;
    this.label = label;
    this.connectionName = connectionName;
    this.fields = fields;
    this.scopes = scopes;
    this.modelName = modelName;
    this.sqlTableName = sqlTableName;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code connectionName} attribute
   */
  @JsonProperty("connection_name")
  @Override
  public String getConnectionName() {
    return connectionName;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty("fields")
  @Override
  public Fields getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code scopes} attribute
   */
  @JsonProperty("scopes")
  @Override
  public List<String> getScopes() {
    return scopes;
  }

  /**
   * @return The value of the {@code modelName} attribute
   */
  @JsonProperty("model_name")
  @Override
  public String getModelName() {
    return modelName;
  }

  /**
   * @return The value of the {@code sqlTableName} attribute
   */
  @JsonProperty("sql_table_name")
  @Override
  public String getSqlTableName() {
    return sqlTableName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        newValue,
        this.name,
        this.label,
        this.connectionName,
        this.fields,
        this.scopes,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        this.id,
        newValue,
        this.label,
        this.connectionName,
        this.fields,
        this.scopes,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        newValue,
        this.connectionName,
        this.fields,
        this.scopes,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getConnectionName() connectionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withConnectionName(String value) {
    String newValue = Objects.requireNonNull(value, "connectionName");
    if (this.connectionName.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        newValue,
        this.fields,
        this.scopes,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getFields() fields} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fields
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withFields(Fields value) {
    if (this.fields == value) return this;
    Fields newValue = Objects.requireNonNull(value, "fields");
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        this.connectionName,
        newValue,
        this.scopes,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExploreDetail#getScopes() scopes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExploreDetail withScopes(String... elements) {
    List<String> newValue = List.of(elements);
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        this.connectionName,
        this.fields,
        newValue,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExploreDetail#getScopes() scopes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of scopes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExploreDetail withScopes(Iterable<String> elements) {
    if (this.scopes == elements) return this;
    List<String> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        this.connectionName,
        this.fields,
        newValue,
        this.modelName,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getModelName() modelName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modelName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withModelName(String value) {
    String newValue = Objects.requireNonNull(value, "modelName");
    if (this.modelName.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        this.connectionName,
        this.fields,
        this.scopes,
        newValue,
        this.sqlTableName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExploreDetail#getSqlTableName() sqlTableName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sqlTableName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExploreDetail withSqlTableName(String value) {
    String newValue = Objects.requireNonNull(value, "sqlTableName");
    if (this.sqlTableName.equals(newValue)) return this;
    return new ImmutableExploreDetail(
        this.id,
        this.name,
        this.label,
        this.connectionName,
        this.fields,
        this.scopes,
        this.modelName,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExploreDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExploreDetail
        && equalTo(0, (ImmutableExploreDetail) another);
  }

  private boolean equalTo(int synthetic, ImmutableExploreDetail another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && label.equals(another.label)
        && connectionName.equals(another.connectionName)
        && fields.equals(another.fields)
        && scopes.equals(another.scopes)
        && modelName.equals(another.modelName)
        && sqlTableName.equals(another.sqlTableName);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code label}, {@code connectionName}, {@code fields}, {@code scopes}, {@code modelName}, {@code sqlTableName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + connectionName.hashCode();
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + scopes.hashCode();
    h += (h << 5) + modelName.hashCode();
    h += (h << 5) + sqlTableName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExploreDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExploreDetail{"
        + "id=" + id
        + ", name=" + name
        + ", label=" + label
        + ", connectionName=" + connectionName
        + ", fields=" + fields
        + ", scopes=" + scopes
        + ", modelName=" + modelName
        + ", sqlTableName=" + sqlTableName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ExploreDetail", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ExploreDetail {
    String id;
    String name;
    String label;
    String connectionName;
    Fields fields;
    List<String> scopes = List.of();
    String modelName;
    String sqlTableName;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("label")
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty("connection_name")
    public void setConnectionName(String connectionName) {
      this.connectionName = connectionName;
    }
    @JsonProperty("fields")
    public void setFields(Fields fields) {
      this.fields = fields;
    }
    @JsonProperty("scopes")
    public void setScopes(List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("model_name")
    public void setModelName(String modelName) {
      this.modelName = modelName;
    }
    @JsonProperty("sql_table_name")
    public void setSqlTableName(String sqlTableName) {
      this.sqlTableName = sqlTableName;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getConnectionName() { throw new UnsupportedOperationException(); }
    @Override
    public Fields getFields() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getModelName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSqlTableName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableExploreDetail fromJson(Json json) {
    ImmutableExploreDetail.Builder builder = ImmutableExploreDetail.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.connectionName != null) {
      builder.connectionName(json.connectionName);
    }
    if (json.fields != null) {
      builder.fields(json.fields);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.modelName != null) {
      builder.modelName(json.modelName);
    }
    if (json.sqlTableName != null) {
      builder.sqlTableName(json.sqlTableName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ExploreDetail} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExploreDetail instance
   */
  public static ImmutableExploreDetail copyOf(ExploreDetail instance) {
    if (instance instanceof ImmutableExploreDetail) {
      return (ImmutableExploreDetail) instance;
    }
    return ImmutableExploreDetail.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExploreDetail ImmutableExploreDetail}.
   * <pre>
   * ImmutableExploreDetail.builder()
   *    .id(String) // required {@link ExploreDetail#getId() id}
   *    .name(String) // required {@link ExploreDetail#getName() name}
   *    .label(String) // required {@link ExploreDetail#getLabel() label}
   *    .connectionName(String) // required {@link ExploreDetail#getConnectionName() connectionName}
   *    .fields(zeenea.connector.looker.client.model.Fields) // required {@link ExploreDetail#getFields() fields}
   *    .addScopes|addAllScopes(String) // {@link ExploreDetail#getScopes() scopes} elements
   *    .modelName(String) // required {@link ExploreDetail#getModelName() modelName}
   *    .sqlTableName(String) // required {@link ExploreDetail#getSqlTableName() sqlTableName}
   *    .build();
   * </pre>
   * @return A new ImmutableExploreDetail builder
   */
  public static ImmutableExploreDetail.Builder builder() {
    return new ImmutableExploreDetail.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExploreDetail ImmutableExploreDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExploreDetail", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_LABEL = 0x4L;
    private static final long INIT_BIT_CONNECTION_NAME = 0x8L;
    private static final long INIT_BIT_FIELDS = 0x10L;
    private static final long INIT_BIT_MODEL_NAME = 0x20L;
    private static final long INIT_BIT_SQL_TABLE_NAME = 0x40L;
    private long initBits = 0x7fL;

    private String id;
    private String name;
    private String label;
    private String connectionName;
    private Fields fields;
    private List<String> scopes = new ArrayList<String>();
    private String modelName;
    private String sqlTableName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExploreDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExploreDetail instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.name(instance.getName());
      this.label(instance.getLabel());
      this.connectionName(instance.getConnectionName());
      this.fields(instance.getFields());
      addAllScopes(instance.getScopes());
      this.modelName(instance.getModelName());
      this.sqlTableName(instance.getSqlTableName());
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getConnectionName() connectionName} attribute.
     * @param connectionName The value for connectionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("connection_name")
    public final Builder connectionName(String connectionName) {
      this.connectionName = Objects.requireNonNull(connectionName, "connectionName");
      initBits &= ~INIT_BIT_CONNECTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getFields() fields} attribute.
     * @param fields The value for fields 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fields")
    public final Builder fields(Fields fields) {
      this.fields = Objects.requireNonNull(fields, "fields");
      initBits &= ~INIT_BIT_FIELDS;
      return this;
    }

    /**
     * Adds one element to {@link ExploreDetail#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addScopes(String element) {
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link ExploreDetail#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addScopes(String... elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExploreDetail#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scopes")
    public final Builder scopes(Iterable<String> elements) {
      this.scopes.clear();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link ExploreDetail#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getModelName() modelName} attribute.
     * @param modelName The value for modelName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("model_name")
    public final Builder modelName(String modelName) {
      this.modelName = Objects.requireNonNull(modelName, "modelName");
      initBits &= ~INIT_BIT_MODEL_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ExploreDetail#getSqlTableName() sqlTableName} attribute.
     * @param sqlTableName The value for sqlTableName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sql_table_name")
    public final Builder sqlTableName(String sqlTableName) {
      this.sqlTableName = Objects.requireNonNull(sqlTableName, "sqlTableName");
      initBits &= ~INIT_BIT_SQL_TABLE_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExploreDetail ImmutableExploreDetail}.
     * @return An immutable instance of ExploreDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExploreDetail build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExploreDetail(
          id,
          name,
          label,
          connectionName,
          fields,
          List.copyOf(scopes),
          modelName,
          sqlTableName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      if ((initBits & INIT_BIT_CONNECTION_NAME) != 0) attributes.add("connectionName");
      if ((initBits & INIT_BIT_FIELDS) != 0) attributes.add("fields");
      if ((initBits & INIT_BIT_MODEL_NAME) != 0) attributes.add("modelName");
      if ((initBits & INIT_BIT_SQL_TABLE_NAME) != 0) attributes.add("sqlTableName");
      return "Cannot build ExploreDetail, some of required attributes are not set " + attributes;
    }
  }
}
