package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataVizDetail}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataVizDetail.builder()}.
 */
@Generated(from = "DataVizDetail", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataVizDetail implements DataVizDetail {
  private final String id;
  private final String title;
  private final String description;
  private final @Nullable Instant createdAt;
  private final @Nullable Space space;
  private final List<DashBoardElement> dashBoardElementJSONList;
  private final @Nullable Instant lastViewedAt;
  private final int viewCount;
  private final @Nullable Folder folder;

  private ImmutableDataVizDetail(
      String id,
      String title,
      String description,
      @Nullable Instant createdAt,
      @Nullable Space space,
      List<DashBoardElement> dashBoardElementJSONList,
      @Nullable Instant lastViewedAt,
      int viewCount,
      @Nullable Folder folder) {
    this.id = id;
    this.title = title;
    this.description = description;
    this.createdAt = createdAt;
    this.space = space;
    this.dashBoardElementJSONList = dashBoardElementJSONList;
    this.lastViewedAt = lastViewedAt;
    this.viewCount = viewCount;
    this.folder = folder;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty("title")
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable Instant getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code space} attribute
   */
  @JsonProperty("space")
  @Override
  public @Nullable Space getSpace() {
    return space;
  }

  /**
   * @return The value of the {@code dashBoardElementJSONList} attribute
   */
  @JsonProperty("dashboard_elements")
  @Override
  public List<DashBoardElement> getDashBoardElementJSONList() {
    return dashBoardElementJSONList;
  }

  /**
   * @return The value of the {@code lastViewedAt} attribute
   */
  @JsonProperty("last_viewed_at")
  @Override
  public @Nullable Instant getLastViewedAt() {
    return lastViewedAt;
  }

  /**
   * @return The value of the {@code viewCount} attribute
   */
  @JsonProperty("view_count")
  @Override
  public int getViewCount() {
    return viewCount;
  }

  /**
   * @return The value of the {@code folder} attribute
   */
  @JsonProperty("folder")
  @Override
  public @Nullable Folder getFolder() {
    return folder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDataVizDetail(
        newValue,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableDataVizDetail(
        this.id,
        newValue,
        this.description,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        newValue,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getCreatedAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withCreatedAt(@Nullable Instant value) {
    if (this.createdAt == value) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        value,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getSpace() space} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for space (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withSpace(@Nullable Space value) {
    if (this.space == value) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        value,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataVizDetail withDashBoardElementJSONList(DashBoardElement... elements) {
    List<DashBoardElement> newValue = List.of(elements);
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        newValue,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dashBoardElementJSONList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataVizDetail withDashBoardElementJSONList(Iterable<? extends DashBoardElement> elements) {
    if (this.dashBoardElementJSONList == elements) return this;
    List<DashBoardElement> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DashBoardElement>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        newValue,
        this.lastViewedAt,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getLastViewedAt() lastViewedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastViewedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withLastViewedAt(@Nullable Instant value) {
    if (this.lastViewedAt == value) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        value,
        this.viewCount,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getViewCount() viewCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for viewCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withViewCount(int value) {
    if (this.viewCount == value) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        value,
        this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataVizDetail#getFolder() folder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for folder (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataVizDetail withFolder(@Nullable Folder value) {
    if (this.folder == value) return this;
    return new ImmutableDataVizDetail(
        this.id,
        this.title,
        this.description,
        this.createdAt,
        this.space,
        this.dashBoardElementJSONList,
        this.lastViewedAt,
        this.viewCount,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataVizDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataVizDetail
        && equalTo(0, (ImmutableDataVizDetail) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataVizDetail another) {
    return id.equals(another.id)
        && title.equals(another.title)
        && description.equals(another.description)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(space, another.space)
        && dashBoardElementJSONList.equals(another.dashBoardElementJSONList)
        && Objects.equals(lastViewedAt, another.lastViewedAt)
        && viewCount == another.viewCount
        && Objects.equals(folder, another.folder);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code title}, {@code description}, {@code createdAt}, {@code space}, {@code dashBoardElementJSONList}, {@code lastViewedAt}, {@code viewCount}, {@code folder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + title.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(space);
    h += (h << 5) + dashBoardElementJSONList.hashCode();
    h += (h << 5) + Objects.hashCode(lastViewedAt);
    h += (h << 5) + viewCount;
    h += (h << 5) + Objects.hashCode(folder);
    return h;
  }

  /**
   * Prints the immutable value {@code DataVizDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataVizDetail{"
        + "id=" + id
        + ", title=" + title
        + ", description=" + description
        + ", createdAt=" + createdAt
        + ", space=" + space
        + ", dashBoardElementJSONList=" + dashBoardElementJSONList
        + ", lastViewedAt=" + lastViewedAt
        + ", viewCount=" + viewCount
        + ", folder=" + folder
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataVizDetail", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataVizDetail {
    String id;
    String title;
    String description;
    Instant createdAt;
    Space space;
    List<DashBoardElement> dashBoardElementJSONList = List.of();
    Instant lastViewedAt;
    int viewCount;
    boolean viewCountIsSet;
    Folder folder;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable Instant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("space")
    public void setSpace(@Nullable Space space) {
      this.space = space;
    }
    @JsonProperty("dashboard_elements")
    public void setDashBoardElementJSONList(List<DashBoardElement> dashBoardElementJSONList) {
      this.dashBoardElementJSONList = dashBoardElementJSONList;
    }
    @JsonProperty("last_viewed_at")
    public void setLastViewedAt(@Nullable Instant lastViewedAt) {
      this.lastViewedAt = lastViewedAt;
    }
    @JsonProperty("view_count")
    public void setViewCount(int viewCount) {
      this.viewCount = viewCount;
      this.viewCountIsSet = true;
    }
    @JsonProperty("folder")
    public void setFolder(@Nullable Folder folder) {
      this.folder = folder;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Space getSpace() { throw new UnsupportedOperationException(); }
    @Override
    public List<DashBoardElement> getDashBoardElementJSONList() { throw new UnsupportedOperationException(); }
    @Override
    public Instant getLastViewedAt() { throw new UnsupportedOperationException(); }
    @Override
    public int getViewCount() { throw new UnsupportedOperationException(); }
    @Override
    public Folder getFolder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataVizDetail fromJson(Json json) {
    ImmutableDataVizDetail.Builder builder = ImmutableDataVizDetail.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.space != null) {
      builder.space(json.space);
    }
    if (json.dashBoardElementJSONList != null) {
      builder.addAllDashBoardElementJSONList(json.dashBoardElementJSONList);
    }
    if (json.lastViewedAt != null) {
      builder.lastViewedAt(json.lastViewedAt);
    }
    if (json.viewCountIsSet) {
      builder.viewCount(json.viewCount);
    }
    if (json.folder != null) {
      builder.folder(json.folder);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataVizDetail} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataVizDetail instance
   */
  public static ImmutableDataVizDetail copyOf(DataVizDetail instance) {
    if (instance instanceof ImmutableDataVizDetail) {
      return (ImmutableDataVizDetail) instance;
    }
    return ImmutableDataVizDetail.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataVizDetail ImmutableDataVizDetail}.
   * <pre>
   * ImmutableDataVizDetail.builder()
   *    .id(String) // required {@link DataVizDetail#getId() id}
   *    .title(String) // required {@link DataVizDetail#getTitle() title}
   *    .description(String) // required {@link DataVizDetail#getDescription() description}
   *    .createdAt(java.time.Instant | null) // nullable {@link DataVizDetail#getCreatedAt() createdAt}
   *    .space(zeenea.connector.looker.client.model.Space | null) // nullable {@link DataVizDetail#getSpace() space}
   *    .addDashBoardElementJSONList|addAllDashBoardElementJSONList(zeenea.connector.looker.client.model.DashBoardElement) // {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList} elements
   *    .lastViewedAt(java.time.Instant | null) // nullable {@link DataVizDetail#getLastViewedAt() lastViewedAt}
   *    .viewCount(int) // required {@link DataVizDetail#getViewCount() viewCount}
   *    .folder(zeenea.connector.looker.client.model.Folder | null) // nullable {@link DataVizDetail#getFolder() folder}
   *    .build();
   * </pre>
   * @return A new ImmutableDataVizDetail builder
   */
  public static ImmutableDataVizDetail.Builder builder() {
    return new ImmutableDataVizDetail.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataVizDetail ImmutableDataVizDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataVizDetail", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long INIT_BIT_VIEW_COUNT = 0x8L;
    private long initBits = 0xfL;

    private String id;
    private String title;
    private String description;
    private Instant createdAt;
    private Space space;
    private List<DashBoardElement> dashBoardElementJSONList = new ArrayList<DashBoardElement>();
    private Instant lastViewedAt;
    private int viewCount;
    private Folder folder;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataVizDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataVizDetail instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.title(instance.getTitle());
      this.description(instance.getDescription());
      @Nullable Instant createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      @Nullable Space spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      addAllDashBoardElementJSONList(instance.getDashBoardElementJSONList());
      @Nullable Instant lastViewedAtValue = instance.getLastViewedAt();
      if (lastViewedAtValue != null) {
        lastViewedAt(lastViewedAtValue);
      }
      this.viewCount(instance.getViewCount());
      @Nullable Folder folderValue = instance.getFolder();
      if (folderValue != null) {
        folder(folderValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable Instant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(@Nullable Space space) {
      this.space = space;
      return this;
    }

    /**
     * Adds one element to {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList} list.
     * @param element A dashBoardElementJSONList element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDashBoardElementJSONList(DashBoardElement element) {
      this.dashBoardElementJSONList.add(Objects.requireNonNull(element, "dashBoardElementJSONList element"));
      return this;
    }

    /**
     * Adds elements to {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList} list.
     * @param elements An array of dashBoardElementJSONList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDashBoardElementJSONList(DashBoardElement... elements) {
      for (DashBoardElement element : elements) {
        this.dashBoardElementJSONList.add(Objects.requireNonNull(element, "dashBoardElementJSONList element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList} list.
     * @param elements An iterable of dashBoardElementJSONList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_elements")
    public final Builder dashBoardElementJSONList(Iterable<? extends DashBoardElement> elements) {
      this.dashBoardElementJSONList.clear();
      return addAllDashBoardElementJSONList(elements);
    }

    /**
     * Adds elements to {@link DataVizDetail#getDashBoardElementJSONList() dashBoardElementJSONList} list.
     * @param elements An iterable of dashBoardElementJSONList elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDashBoardElementJSONList(Iterable<? extends DashBoardElement> elements) {
      for (DashBoardElement element : elements) {
        this.dashBoardElementJSONList.add(Objects.requireNonNull(element, "dashBoardElementJSONList element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getLastViewedAt() lastViewedAt} attribute.
     * @param lastViewedAt The value for lastViewedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_viewed_at")
    public final Builder lastViewedAt(@Nullable Instant lastViewedAt) {
      this.lastViewedAt = lastViewedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getViewCount() viewCount} attribute.
     * @param viewCount The value for viewCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view_count")
    public final Builder viewCount(int viewCount) {
      this.viewCount = viewCount;
      initBits &= ~INIT_BIT_VIEW_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link DataVizDetail#getFolder() folder} attribute.
     * @param folder The value for folder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("folder")
    public final Builder folder(@Nullable Folder folder) {
      this.folder = folder;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataVizDetail ImmutableDataVizDetail}.
     * @return An immutable instance of DataVizDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataVizDetail build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataVizDetail(
          id,
          title,
          description,
          createdAt,
          space,
          List.copyOf(dashBoardElementJSONList),
          lastViewedAt,
          viewCount,
          folder);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_VIEW_COUNT) != 0) attributes.add("viewCount");
      return "Cannot build DataVizDetail, some of required attributes are not set " + attributes;
    }
  }
}
