package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataViz}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataViz.builder()}.
 */
@Generated(from = "DataViz", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDataViz implements DataViz {
  private final String id;
  private final String title;
  private final Folder folder;

  private ImmutableDataViz(String id, String title, Folder folder) {
    this.id = id;
    this.title = title;
    this.folder = folder;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty("title")
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code folder} attribute
   */
  @JsonProperty("folder")
  @Override
  public Folder getFolder() {
    return folder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataViz#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataViz withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDataViz(newValue, this.title, this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataViz#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataViz withTitle(String value) {
    String newValue = Objects.requireNonNull(value, "title");
    if (this.title.equals(newValue)) return this;
    return new ImmutableDataViz(this.id, newValue, this.folder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataViz#getFolder() folder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for folder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataViz withFolder(Folder value) {
    if (this.folder == value) return this;
    Folder newValue = Objects.requireNonNull(value, "folder");
    return new ImmutableDataViz(this.id, this.title, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataViz} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataViz
        && equalTo(0, (ImmutableDataViz) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataViz another) {
    return id.equals(another.id)
        && title.equals(another.title)
        && folder.equals(another.folder);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code title}, {@code folder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + title.hashCode();
    h += (h << 5) + folder.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DataViz} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataViz{"
        + "id=" + id
        + ", title=" + title
        + ", folder=" + folder
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataViz", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataViz {
    String id;
    String title;
    Folder folder;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("folder")
    public void setFolder(Folder folder) {
      this.folder = folder;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Folder getFolder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataViz fromJson(Json json) {
    ImmutableDataViz.Builder builder = ImmutableDataViz.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.folder != null) {
      builder.folder(json.folder);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataViz} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataViz instance
   */
  public static ImmutableDataViz copyOf(DataViz instance) {
    if (instance instanceof ImmutableDataViz) {
      return (ImmutableDataViz) instance;
    }
    return ImmutableDataViz.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataViz ImmutableDataViz}.
   * <pre>
   * ImmutableDataViz.builder()
   *    .id(String) // required {@link DataViz#getId() id}
   *    .title(String) // required {@link DataViz#getTitle() title}
   *    .folder(zeenea.connector.looker.client.model.Folder) // required {@link DataViz#getFolder() folder}
   *    .build();
   * </pre>
   * @return A new ImmutableDataViz builder
   */
  public static ImmutableDataViz.Builder builder() {
    return new ImmutableDataViz.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataViz ImmutableDataViz}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataViz", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TITLE = 0x2L;
    private static final long INIT_BIT_FOLDER = 0x4L;
    private long initBits = 0x7L;

    private String id;
    private String title;
    private Folder folder;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataViz} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataViz instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.title(instance.getTitle());
      this.folder(instance.getFolder());
      return this;
    }

    /**
     * Initializes the value for the {@link DataViz#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataViz#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("title")
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link DataViz#getFolder() folder} attribute.
     * @param folder The value for folder 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("folder")
    public final Builder folder(Folder folder) {
      this.folder = Objects.requireNonNull(folder, "folder");
      initBits &= ~INIT_BIT_FOLDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataViz ImmutableDataViz}.
     * @return An immutable instance of DataViz
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataViz build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataViz(id, title, folder);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_FOLDER) != 0) attributes.add("folder");
      return "Cannot build DataViz, some of required attributes are not set " + attributes;
    }
  }
}
