package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DashBoardElement}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDashBoardElement.builder()}.
 */
@Generated(from = "DashBoardElement", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDashBoardElement implements DashBoardElement {
  private final @Nullable ResultMaker resultMakerJSON;

  private ImmutableDashBoardElement(
      @Nullable ResultMaker resultMakerJSON) {
    this.resultMakerJSON = resultMakerJSON;
  }

  /**
   * @return The value of the {@code resultMakerJSON} attribute
   */
  @JsonProperty("result_maker")
  @Override
  public @Nullable ResultMaker getResultMakerJSON() {
    return resultMakerJSON;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DashBoardElement#getResultMakerJSON() resultMakerJSON} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resultMakerJSON (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDashBoardElement withResultMakerJSON(@Nullable ResultMaker value) {
    if (this.resultMakerJSON == value) return this;
    return new ImmutableDashBoardElement(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDashBoardElement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDashBoardElement
        && equalTo(0, (ImmutableDashBoardElement) another);
  }

  private boolean equalTo(int synthetic, ImmutableDashBoardElement another) {
    return Objects.equals(resultMakerJSON, another.resultMakerJSON);
  }

  /**
   * Computes a hash code from attributes: {@code resultMakerJSON}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(resultMakerJSON);
    return h;
  }

  /**
   * Prints the immutable value {@code DashBoardElement} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DashBoardElement{"
        + "resultMakerJSON=" + resultMakerJSON
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DashBoardElement", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DashBoardElement {
    ResultMaker resultMakerJSON;
    @JsonProperty("result_maker")
    public void setResultMakerJSON(@Nullable ResultMaker resultMakerJSON) {
      this.resultMakerJSON = resultMakerJSON;
    }
    @Override
    public ResultMaker getResultMakerJSON() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDashBoardElement fromJson(Json json) {
    ImmutableDashBoardElement.Builder builder = ImmutableDashBoardElement.builder();
    if (json.resultMakerJSON != null) {
      builder.resultMakerJSON(json.resultMakerJSON);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DashBoardElement} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DashBoardElement instance
   */
  public static ImmutableDashBoardElement copyOf(DashBoardElement instance) {
    if (instance instanceof ImmutableDashBoardElement) {
      return (ImmutableDashBoardElement) instance;
    }
    return ImmutableDashBoardElement.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDashBoardElement ImmutableDashBoardElement}.
   * <pre>
   * ImmutableDashBoardElement.builder()
   *    .resultMakerJSON(zeenea.connector.looker.client.model.ResultMaker | null) // nullable {@link DashBoardElement#getResultMakerJSON() resultMakerJSON}
   *    .build();
   * </pre>
   * @return A new ImmutableDashBoardElement builder
   */
  public static ImmutableDashBoardElement.Builder builder() {
    return new ImmutableDashBoardElement.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDashBoardElement ImmutableDashBoardElement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DashBoardElement", generator = "Immutables")
  public static final class Builder {
    private ResultMaker resultMakerJSON;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DashBoardElement} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DashBoardElement instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable ResultMaker resultMakerJSONValue = instance.getResultMakerJSON();
      if (resultMakerJSONValue != null) {
        resultMakerJSON(resultMakerJSONValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DashBoardElement#getResultMakerJSON() resultMakerJSON} attribute.
     * @param resultMakerJSON The value for resultMakerJSON (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("result_maker")
    public final Builder resultMakerJSON(@Nullable ResultMaker resultMakerJSON) {
      this.resultMakerJSON = resultMakerJSON;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDashBoardElement ImmutableDashBoardElement}.
     * @return An immutable instance of DashBoardElement
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDashBoardElement build() {
      return new ImmutableDashBoardElement(resultMakerJSON);
    }
  }
}
