package zeenea.connector.looker.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Connection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConnection.builder()}.
 */
@Generated(from = "Connection", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableConnection implements Connection {
  private final @Nullable String name;
  private final @Nullable String host;
  private final @Nullable String port;
  private final @Nullable String database;
  private final String dialectName;
  private final String jdbcAdditionalParams;

  private ImmutableConnection(
      @Nullable String name,
      @Nullable String host,
      @Nullable String port,
      @Nullable String database,
      String dialectName,
      String jdbcAdditionalParams) {
    this.name = name;
    this.host = host;
    this.port = port;
    this.database = database;
    this.dialectName = dialectName;
    this.jdbcAdditionalParams = jdbcAdditionalParams;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public @Nullable String getPort() {
    return port;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public @Nullable String getDatabase() {
    return database;
  }

  /**
   * @return The value of the {@code dialectName} attribute
   */
  @JsonProperty("dialect_name")
  @Override
  public String getDialectName() {
    return dialectName;
  }

  /**
   * @return The value of the {@code jdbcAdditionalParams} attribute
   */
  @JsonProperty("jdbc_additional_params")
  @Override
  public String getJdbcAdditionalParams() {
    return jdbcAdditionalParams;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableConnection(value, this.host, this.port, this.database, this.dialectName, this.jdbcAdditionalParams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withHost(@Nullable String value) {
    if (Objects.equals(this.host, value)) return this;
    return new ImmutableConnection(this.name, value, this.port, this.database, this.dialectName, this.jdbcAdditionalParams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getPort() port} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withPort(@Nullable String value) {
    if (Objects.equals(this.port, value)) return this;
    return new ImmutableConnection(this.name, this.host, value, this.database, this.dialectName, this.jdbcAdditionalParams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withDatabase(@Nullable String value) {
    if (Objects.equals(this.database, value)) return this;
    return new ImmutableConnection(this.name, this.host, this.port, value, this.dialectName, this.jdbcAdditionalParams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getDialectName() dialectName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dialectName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withDialectName(String value) {
    String newValue = Objects.requireNonNull(value, "dialectName");
    if (this.dialectName.equals(newValue)) return this;
    return new ImmutableConnection(this.name, this.host, this.port, this.database, newValue, this.jdbcAdditionalParams);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getJdbcAdditionalParams() jdbcAdditionalParams} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for jdbcAdditionalParams
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withJdbcAdditionalParams(String value) {
    String newValue = Objects.requireNonNull(value, "jdbcAdditionalParams");
    if (this.jdbcAdditionalParams.equals(newValue)) return this;
    return new ImmutableConnection(this.name, this.host, this.port, this.database, this.dialectName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnection
        && equalTo(0, (ImmutableConnection) another);
  }

  private boolean equalTo(int synthetic, ImmutableConnection another) {
    return Objects.equals(name, another.name)
        && Objects.equals(host, another.host)
        && Objects.equals(port, another.port)
        && Objects.equals(database, another.database)
        && dialectName.equals(another.dialectName)
        && jdbcAdditionalParams.equals(another.jdbcAdditionalParams);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code host}, {@code port}, {@code database}, {@code dialectName}, {@code jdbcAdditionalParams}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(database);
    h += (h << 5) + dialectName.hashCode();
    h += (h << 5) + jdbcAdditionalParams.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Connection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Connection{"
        + "name=" + name
        + ", host=" + host
        + ", port=" + port
        + ", database=" + database
        + ", dialectName=" + dialectName
        + ", jdbcAdditionalParams=" + jdbcAdditionalParams
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Connection", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Connection {
    String name;
    String host;
    String port;
    String database;
    String dialectName;
    String jdbcAdditionalParams;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("port")
    public void setPort(@Nullable String port) {
      this.port = port;
    }
    @JsonProperty("database")
    public void setDatabase(@Nullable String database) {
      this.database = database;
    }
    @JsonProperty("dialect_name")
    public void setDialectName(String dialectName) {
      this.dialectName = dialectName;
    }
    @JsonProperty("jdbc_additional_params")
    public void setJdbcAdditionalParams(String jdbcAdditionalParams) {
      this.jdbcAdditionalParams = jdbcAdditionalParams;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatabase() { throw new UnsupportedOperationException(); }
    @Override
    public String getDialectName() { throw new UnsupportedOperationException(); }
    @Override
    public String getJdbcAdditionalParams() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConnection fromJson(Json json) {
    ImmutableConnection.Builder builder = ImmutableConnection.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.database != null) {
      builder.database(json.database);
    }
    if (json.dialectName != null) {
      builder.dialectName(json.dialectName);
    }
    if (json.jdbcAdditionalParams != null) {
      builder.jdbcAdditionalParams(json.jdbcAdditionalParams);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Connection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Connection instance
   */
  public static ImmutableConnection copyOf(Connection instance) {
    if (instance instanceof ImmutableConnection) {
      return (ImmutableConnection) instance;
    }
    return ImmutableConnection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConnection ImmutableConnection}.
   * <pre>
   * ImmutableConnection.builder()
   *    .name(String | null) // nullable {@link Connection#getName() name}
   *    .host(String | null) // nullable {@link Connection#getHost() host}
   *    .port(String | null) // nullable {@link Connection#getPort() port}
   *    .database(String | null) // nullable {@link Connection#getDatabase() database}
   *    .dialectName(String) // required {@link Connection#getDialectName() dialectName}
   *    .jdbcAdditionalParams(String) // required {@link Connection#getJdbcAdditionalParams() jdbcAdditionalParams}
   *    .build();
   * </pre>
   * @return A new ImmutableConnection builder
   */
  public static ImmutableConnection.Builder builder() {
    return new ImmutableConnection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConnection ImmutableConnection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Connection", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DIALECT_NAME = 0x1L;
    private static final long INIT_BIT_JDBC_ADDITIONAL_PARAMS = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private String host;
    private String port;
    private String database;
    private String dialectName;
    private String jdbcAdditionalParams;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Connection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Connection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      @Nullable String portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      @Nullable String databaseValue = instance.getDatabase();
      if (databaseValue != null) {
        database(databaseValue);
      }
      this.dialectName(instance.getDialectName());
      this.jdbcAdditionalParams(instance.getJdbcAdditionalParams());
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host")
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(@Nullable String port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getDatabase() database} attribute.
     * @param database The value for database (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("database")
    public final Builder database(@Nullable String database) {
      this.database = database;
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getDialectName() dialectName} attribute.
     * @param dialectName The value for dialectName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dialect_name")
    public final Builder dialectName(String dialectName) {
      this.dialectName = Objects.requireNonNull(dialectName, "dialectName");
      initBits &= ~INIT_BIT_DIALECT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getJdbcAdditionalParams() jdbcAdditionalParams} attribute.
     * @param jdbcAdditionalParams The value for jdbcAdditionalParams 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jdbc_additional_params")
    public final Builder jdbcAdditionalParams(String jdbcAdditionalParams) {
      this.jdbcAdditionalParams = Objects.requireNonNull(jdbcAdditionalParams, "jdbcAdditionalParams");
      initBits &= ~INIT_BIT_JDBC_ADDITIONAL_PARAMS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnection ImmutableConnection}.
     * @return An immutable instance of Connection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnection build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConnection(name, host, port, database, dialectName, jdbcAdditionalParams);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DIALECT_NAME) != 0) attributes.add("dialectName");
      if ((initBits & INIT_BIT_JDBC_ADDITIONAL_PARAMS) != 0) attributes.add("jdbcAdditionalParams");
      return "Cannot build Connection, some of required attributes are not set " + attributes;
    }
  }
}
