/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.db;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zeenea.connector.commons.util.Pair;

public class ConnectionStrings {
    private static final Pattern filePattern = Pattern.compile("^(?:\\w:\\\\|/)");
    private static final Pattern valuesPattern = Pattern.compile("(server|host|port|data\\s*source(?:\\s*name)?|(?:file)?dsn|database|uid|user\\s*id|initial\\s*catalog|provider)\\s*=\\s*([^;]*|\"([^\"]*\"\")*[^\"]*\"|'([^']*'')*[^']*)\\s*(?:;|$)", 2);

    public static List<Pair<String, String>> parsePairList(String s) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        ConnectionStrings.parse(s, (k, v) -> result.add(Pair.of(k, v)));
        return result;
    }

    public static Map<String, String> parseMap(String s) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        ConnectionStrings.parse(s, result::put);
        return result;
    }

    public static void parse(String s, BiConsumer<String, String> consumer) {
        if (filePattern.matcher(s).find()) {
            consumer.accept("file", s);
        } else {
            Matcher matcher = valuesPattern.matcher(s);
            while (matcher.find()) {
                consumer.accept(ConnectionStrings.cleanKey(matcher.group(1)), ConnectionStrings.cleanValue(matcher.group(2)));
            }
        }
    }

    private static String cleanKey(String key) {
        return key.trim().toLowerCase(Locale.ROOT);
    }

    private static String cleanValue(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1).replace("\"\"", "\"");
        }
        if (s.startsWith("'")) {
            return s.substring(1, s.length() - 1).replace("''", "'");
        }
        return s.trim();
    }
}

