/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api.quota;

import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nullable;

public class QuotaTicket {
    private static final QuotaTicket GRANTED = new QuotaTicket(true, null);
    private final boolean isGranted;
    @Nullable
    private final Instant deadline;

    private QuotaTicket(boolean isGranted, @Nullable Instant deadline) {
        this.isGranted = isGranted;
        this.deadline = deadline;
    }

    public static QuotaTicket granted() {
        return GRANTED;
    }

    public static QuotaTicket denied(Instant timestamp) {
        return new QuotaTicket(false, Objects.requireNonNull(timestamp));
    }

    public boolean isGranted() {
        return this.isGranted;
    }

    public Instant deadline() {
        return this.deadline;
    }

    public String toString() {
        return new StringJoiner(", ", QuotaTicket.class.getSimpleName() + "[", "]").add("isGranted=" + this.isGranted).add("deadline=" + this.deadline).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuotaTicket that = (QuotaTicket)o;
        return this.isGranted == that.isGranted && Objects.equals(this.deadline, that.deadline);
    }

    public int hashCode() {
        return Objects.hash(this.isGranted, this.deadline);
    }
}

