/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.http.client.RestClient;
import zeenea.connector.commons.http.client.RestClientConfigException;
import zeenea.connector.commons.http.client.RestOptions;
import zeenea.connector.commons.http.client.RestRequest;
import zeenea.connector.commons.http.client.auth.AuthHandler;
import zeenea.connector.commons.http.client.auth.OAuth2AccessTokenResponse;
import zeenea.connector.commons.http.client.auth.OAuth2Configuration;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.util.Pair;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

public class OAuth2AuthHandler
implements AuthHandler {
    @NotNull
    private final URI endpoint;
    @NotNull
    private final List<Pair<String, String>> clientCredentials;
    @Nullable
    private final List<String> scope;
    @Nullable
    private final String resource;
    @Nullable
    private List<Pair<String, String>> token;
    @Nullable
    private Instant expiresAt;

    private OAuth2AuthHandler(Builder builder) {
        this.endpoint = Objects.requireNonNull(builder.endpoint, "endpoint");
        String creds = Objects.requireNonNull(builder.clientId, "clientId") + ":" + Objects.requireNonNull(builder.clientSecret, "clientSecret");
        String basic = "Basic " + Base64.getEncoder().encodeToString(creds.getBytes(StandardCharsets.UTF_8));
        this.clientCredentials = Collections.singletonList(Pair.of((Object)"Authorization", (Object)basic));
        this.scope = builder.scope;
        this.resource = builder.resource;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<Pair<String, String>> authenticationHeaders(TracingContext ctx, RestClient client) {
        if (this.token != null && this.expiresAt != null && this.expiresAt.isAfter(Instant.now())) {
            return this.token;
        }
        RestRequest<OAuth2AccessTokenResponse> request = RestRequest.builder(OAuth2AccessTokenResponse.class).ctx(ctx).base(this.endpoint).headers(this.clientCredentials).options(RestOptions.NO_AUTH, RestOptions.FORM_ENCODED).build();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "client_credentials");
        if (this.scope != null) {
            params.put("scope", String.join((CharSequence)" ", this.scope));
        }
        if (this.resource != null) {
            params.put("resource", this.resource);
        }
        Instant now = Instant.now();
        OAuth2AccessTokenResponse post = client.post(request, params);
        if (post != null) {
            this.token = Collections.singletonList(Pair.of((Object)"Authorization", (Object)("Bearer " + post.getAccessToken())));
            this.expiresAt = now.plusSeconds(post.getExpiresIn());
        } else {
            this.reset();
        }
        return this.token;
    }

    @Override
    public boolean retryOnUnauthorized() {
        return true;
    }

    @Override
    public void reset() {
        this.token = null;
        this.expiresAt = null;
    }

    public static class Builder {
        private URI endpoint;
        private String clientId;
        private String clientSecret;
        private List<String> scope;
        private String resource;
        private boolean configRead;

        private Builder() {
        }

        public Builder configuration(@NotNull PropertyValueMap configuration) {
            this.configRead = true;
            configuration.get((SourceStringProperty)OAuth2Configuration.OAUTH_ENDPOINT).ifPresent(endpoint -> {
                try {
                    this.endpoint = new URI((String)endpoint);
                }
                catch (URISyntaxException e) {
                    throw new ConnectorConfigurationException((SourceProperty)OAuth2Configuration.OAUTH_ENDPOINT, "Invalid OAuth2 endpoint URI", (Throwable)e);
                }
            });
            configuration.get((SourceStringProperty)OAuth2Configuration.CLIENT_ID).ifPresent(id -> {
                this.clientId = id;
            });
            configuration.get((SourceStringProperty)OAuth2Configuration.CLIENT_SECRET).ifPresent(secret -> {
                this.clientSecret = secret;
            });
            configuration.get((SourceStringProperty)OAuth2Configuration.SCOPE).map(s -> Arrays.asList(s.split(" "))).ifPresent(scope -> {
                this.scope = scope;
            });
            return this;
        }

        public Builder endpoint(URI uri) {
            this.endpoint = uri;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder scope(List<String> scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(String ... scope) {
            this.scope = Arrays.asList(scope);
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Nullable
        public OAuth2AuthHandler build() {
            if (this.endpoint == null) {
                RestClientConfigException.throwConfigException(this.configRead, (SourceProperty)OAuth2Configuration.OAUTH_ENDPOINT, "OAuth2 endpoint URI is required");
            }
            if (this.clientId == null) {
                RestClientConfigException.throwConfigException(this.configRead, (SourceProperty)OAuth2Configuration.CLIENT_ID, "Client ID is required");
            }
            if (this.clientSecret == null) {
                RestClientConfigException.throwConfigException(this.configRead, (SourceProperty)OAuth2Configuration.CLIENT_SECRET, "Client secret is required");
            }
            return new OAuth2AuthHandler(this);
        }
    }
}

