/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.HeapWritableBufferImpl;
import org.apache.datasketches.memory.NonNativeWritableBufferImpl;

final class HeapNonNativeWritableBufferImpl
extends NonNativeWritableBufferImpl {
    private static final int id = 96;
    private final Object unsafeObj;
    private final byte typeId;

    HeapNonNativeWritableBufferImpl(Object unsafeObj, long regionOffset, long capacityBytes, int typeId, BaseWritableMemoryImpl originMemory) {
        super(unsafeObj, 0L, regionOffset, capacityBytes, originMemory);
        this.unsafeObj = unsafeObj;
        this.typeId = (byte)(0x60 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return HeapNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.originMemory) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type, this.originMemory);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 4 | (readOnly ? 1 : 0);
        return HeapNonNativeWritableBufferImpl.isNativeByteOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.originMemory) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, this.originMemory);
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

